<?php
use yii\helpers\Html;
use yii\helpers\Url;

$this->title = Html::encode($tour->title) . ' | Weekend Tours';
?>

<style>
    :root {
        --primary-green: #4CAF7D;
        --light-green: #E8F5E9;
        --accent-green: #81C784;
        --dark-green: #388E3C;
        --white: #FFFFFF;
        --gray-light: #F5F5F5;
        --gray: #757575;
        --gray-dark: #424242;
    }

    .tour-detail-page {
        min-height: 100vh;
        background: linear-gradient(135deg, var(--light-green) 0%, var(--white) 100%);
        padding: 40px 0;
    }

    /* Анимированный заголовок */
    .tour-header {
        position: relative;
        margin-bottom: 50px;
        overflow: hidden;
    }

    .tour-title {
        font-size: 3.5rem;
        font-weight: 800;
        background: linear-gradient(45deg, var(--dark-green), var(--primary-green));
        -webkit-background-clip: text;
        -webkit-text-fill-color: transparent;
        margin-bottom: 15px;
        opacity: 0;
        transform: translateY(30px);
        animation: fadeInUp 0.8s ease forwards;
    }

    .tour-meta {
        display: flex;
        gap: 30px;
        align-items: center;
        opacity: 0;
        transform: translateY(30px);
        animation: fadeInUp 0.8s ease 0.3s forwards;
    }

    .tour-price-tag {
        font-size: 2rem;
        color: var(--primary-green);
        font-weight: 700;
        position: relative;
        padding-left: 30px;
    }

    .tour-price-tag::before {
        content: '💰';
        position: absolute;
        left: 0;
        top: 50%;
        transform: translateY(-50%);
        font-size: 1.5rem;
    }

    .tour-duration {
        display: flex;
        align-items: center;
        gap: 8px;
        color: var(--gray);
        font-size: 1.1rem;
        padding: 10px 20px;
        background: var(--white);
        border-radius: 50px;
        box-shadow: 0 5px 15px rgba(76, 175, 125, 0.1);
    }

    .tour-difficulty {
        display: flex;
        align-items: center;
        gap: 8px;
        color: var(--gray);
        font-size: 1.1rem;
        padding: 10px 20px;
        background: var(--white);
        border-radius: 50px;
        box-shadow: 0 5px 15px rgba(76, 175, 125, 0.1);
    }

    /* Основной контент */
    .tour-content {
        display: grid;
        grid-template-columns: 1fr 400px;
        gap: 50px;
        margin-bottom: 60px;
    }

    @media (max-width: 992px) {
        .tour-content {
            grid-template-columns: 1fr;
        }
    }

    /* Галерея */
    .tour-gallery {
        position: relative;
        margin-bottom: 40px;
        opacity: 0;
        transform: translateY(30px);
        animation: fadeInUp 0.8s ease 0.5s forwards;
    }

    .main-image-container {
        position: relative;
        border-radius: 20px;
        overflow: hidden;
        box-shadow: 0 20px 40px rgba(76, 175, 125, 0.15);
        margin-bottom: 20px;
        height: 500px;
    }

    .main-image {
        width: 100%;
        height: 100%;
        object-fit: cover;
        transition: transform 0.6s ease;
    }

    .main-image:hover {
        transform: scale(1.05);
    }

    .image-badge {
        position: absolute;
        top: 20px;
        right: 20px;
        background: var(--primary-green);
        color: var(--white);
        padding: 10px 20px;
        border-radius: 50px;
        font-weight: 600;
        font-size: 0.9rem;
        z-index: 2;
        transform: translateX(20px);
        opacity: 0;
        animation: slideInRight 0.5s ease 1s forwards;
    }

    .thumbnail-grid {
        display: grid;
        grid-template-columns: repeat(4, 1fr);
        gap: 15px;
    }

    .thumbnail {
        width: 100%;
        height: 100px;
        object-fit: cover;
        border-radius: 10px;
        cursor: pointer;
        transition: all 0.3s ease;
        opacity: 0;
        transform: scale(0.9);
    }

    .thumbnail:nth-child(1) { animation: fadeInScale 0.5s ease 0.6s forwards; }
    .thumbnail:nth-child(2) { animation: fadeInScale 0.5s ease 0.7s forwards; }
    .thumbnail:nth-child(3) { animation: fadeInScale 0.5s ease 0.8s forwards; }
    .thumbnail:nth-child(4) { animation: fadeInScale 0.5s ease 0.9s forwards; }

    .thumbnail:hover {
        transform: scale(1.05);
        box-shadow: 0 10px 20px rgba(0,0,0,0.1);
    }

    .thumbnail.active {
        border: 3px solid var(--primary-green);
        transform: scale(1.05);
    }

    /* Информационные секции */
    .info-section {
        background: var(--white);
        padding: 40px;
        border-radius: 20px;
        box-shadow: 0 10px 30px rgba(76, 175, 125, 0.1);
        margin-bottom: 30px;
        opacity: 0;
        transform: translateY(30px);
    }

    .info-section:nth-child(1) { animation: fadeInUp 0.8s ease 0.7s forwards; }
    .info-section:nth-child(2) { animation: fadeInUp 0.8s ease 0.9s forwards; }

    .section-title {
        color: var(--dark-green);
        font-size: 1.8rem;
        margin-bottom: 25px;
        position: relative;
        padding-bottom: 15px;
    }

    .section-title::after {
        content: '';
        position: absolute;
        bottom: 0;
        left: 0;
        width: 60px;
        height: 3px;
        background: var(--primary-green);
        border-radius: 2px;
    }

    .description-text {
        color: var(--gray-dark);
        line-height: 1.8;
        font-size: 1.1rem;
    }

    .program-list {
        list-style: none;
        padding: 0;
    }

    .program-item {
        display: flex;
        gap: 20px;
        padding: 20px 0;
        border-bottom: 2px solid var(--light-green);
        opacity: 0;
        transform: translateX(-20px);
    }

    .program-item:last-child {
        border-bottom: none;
    }

    .program-item:nth-child(1) { animation: slideInRight 0.5s ease 0.8s forwards; }
    .program-item:nth-child(2) { animation: slideInRight 0.5s ease 0.9s forwards; }
    .program-item:nth-child(3) { animation: slideInRight 0.5s ease 1s forwards; }

    .program-time {
        min-width: 80px;
        color: var(--primary-green);
        font-weight: 600;
        font-size: 1.1rem;
    }

    .program-content h4 {
        color: var(--dark-green);
        margin-bottom: 8px;
    }

    .program-content p {
        color: var(--gray);
        line-height: 1.6;
    }

    /* Боковая панель */
    .sidebar {
        position: sticky;
        top: 100px;
        height: fit-content;
    }

    .booking-card {
        background: var(--white);
        border-radius: 20px;
        padding: 40px;
        box-shadow: 0 20px 40px rgba(76, 175, 125, 0.15);
        text-align: center;
        margin-bottom: 30px;
        opacity: 0;
        transform: translateY(30px);
        animation: fadeInUp 0.8s ease 1.1s forwards;
    }

    .booking-price {
        font-size: 3rem;
        color: var(--primary-green);
        font-weight: 800;
        margin: 20px 0;
        position: relative;
    }

    .booking-price::after {
        content: '₽';
        font-size: 1.5rem;
        margin-left: 5px;
    }

    .booking-features {
        list-style: none;
        padding: 0;
        margin: 25px 0;
    }

    .booking-features li {
        display: flex;
        align-items: center;
        gap: 10px;
        padding: 12px 0;
        color: var(--gray-dark);
        border-bottom: 1px solid var(--light-green);
    }

    .booking-features li:last-child {
        border-bottom: none;
    }

    .booking-features li::before {
        content: '✓';
        color: var(--primary-green);
        font-weight: bold;
    }

    .booking-button {
        display: inline-flex;
        align-items: center;
        justify-content: center;
        gap: 15px;
        width: 100%;
        padding: 20px;
        background: linear-gradient(45deg, var(--primary-green), var(--accent-green));
        color: var(--white);
        text-decoration: none;
        border-radius: 15px;
        font-size: 1.2rem;
        font-weight: 700;
        border: none;
        cursor: pointer;
        transition: all 0.3s ease;
        margin-top: 20px;
        position: relative;
        overflow: hidden;
    }

    .booking-button::before {
        content: '';
        position: absolute;
        top: 0;
        left: -100%;
        width: 100%;
        height: 100%;
        background: linear-gradient(90deg, transparent, rgba(255,255,255,0.2), transparent);
        transition: left 0.5s ease;
    }

    .booking-button:hover::before {
        left: 100%;
    }

    .booking-button:hover {
        transform: translateY(-5px);
        box-shadow: 0 20px 40px rgba(76, 175, 125, 0.3);
    }

    .booking-button::after {
        content: '→';
        font-size: 1.5rem;
        transition: transform 0.3s ease;
    }

    .booking-button:hover::after {
        transform: translateX(10px);
    }

    .login-prompt {
        text-align: center;
        color: var(--gray);
        font-size: 1.1rem;
        padding: 20px;
        background: var(--white);
        border-radius: 15px;
        box-shadow: 0 10px 20px rgba(76, 175, 125, 0.1);
    }

    .login-prompt a {
        color: var(--primary-green);
        text-decoration: none;
        font-weight: 600;
        transition: color 0.3s ease;
    }

    .login-prompt a:hover {
        color: var(--dark-green);
        text-decoration: underline;
    }

    /* Включения/исключения */
    .inclusions-section {
        display: grid;
        grid-template-columns: repeat(2, 1fr);
        gap: 30px;
        margin-top: 40px;
        opacity: 0;
        transform: translateY(30px);
        animation: fadeInUp 0.8s ease 1.3s forwards;
    }

    .inclusions-card {
        background: var(--white);
        padding: 30px;
        border-radius: 15px;
        box-shadow: 0 10px 20px rgba(76, 175, 125, 0.1);
    }

    .inclusions-card h4 {
        color: var(--dark-green);
        margin-bottom: 20px;
        display: flex;
        align-items: center;
        gap: 10px;
    }

    .inclusions-list {
        list-style: none;
        padding: 0;
    }

    .inclusions-list li {
        padding: 10px 0;
        color: var(--gray-dark);
        position: relative;
        padding-left: 30px;
    }

    .inclusions-list li::before {
        position: absolute;
        left: 0;
        top: 12px;
        width: 20px;
        height: 20px;
        display: flex;
        align-items: center;
        justify-content: center;
        font-weight: bold;
    }

    .included li::before {
        content: '✓';
        color: var(--primary-green);
    }

    .excluded li::before {
        content: '✗';
        color: #f44336;
    }

    /* FAQ */
    .faq-section {
        margin-top: 50px;
        opacity: 0;
        transform: translateY(30px);
        animation: fadeInUp 0.8s ease 1.5s forwards;
    }

    .faq-item {
        background: var(--white);
        margin-bottom: 15px;
        border-radius: 15px;
        overflow: hidden;
        box-shadow: 0 5px 15px rgba(76, 175, 125, 0.1);
    }

    .faq-question {
        padding: 20px 30px;
        color: var(--dark-green);
        font-weight: 600;
        cursor: pointer;
        display: flex;
        justify-content: space-between;
        align-items: center;
        transition: all 0.3s ease;
    }

    .faq-question:hover {
        background: var(--light-green);
    }

    .faq-question::after {
        content: '▼';
        font-size: 0.8rem;
        transition: transform 0.3s ease;
    }

    .faq-question.active::after {
        transform: rotate(180deg);
    }

    .faq-answer {
        padding: 0 30px;
        max-height: 0;
        overflow: hidden;
        transition: all 0.3s ease;
        color: var(--gray-dark);
        line-height: 1.6;
    }

    .faq-answer.active {
        padding: 20px 30px;
        max-height: 500px;
    }

    /* Анимации */
    @keyframes fadeInUp {
        from {
            opacity: 0;
            transform: translateY(40px);
        }
        to {
            opacity: 1;
            transform: translateY(0);
        }
    }

    @keyframes slideInRight {
        from {
            opacity: 0;
            transform: translateX(-20px);
        }
        to {
            opacity: 1;
            transform: translateX(0);
        }
    }

    @keyframes fadeInScale {
        from {
            opacity: 0;
            transform: scale(0.9);
        }
        to {
            opacity: 1;
            transform: scale(1);
        }
    }

    /* Back button */
    .back-button {
        display: inline-flex;
        align-items: center;
        gap: 10px;
        padding: 12px 25px;
        background: var(--white);
        color: var(--gray-dark);
        text-decoration: none;
        border-radius: 50px;
        font-weight: 500;
        margin-bottom: 30px;
        transition: all 0.3s ease;
        box-shadow: 0 5px 15px rgba(76, 175, 125, 0.1);
    }

    .back-button:hover {
        background: var(--primary-green);
        color: var(--white);
        transform: translateX(-5px);
    }

    .back-button::before {
        content: '←';
        transition: transform 0.3s ease;
    }

    .back-button:hover::before {
        transform: translateX(-5px);
    }

    /* Дополнительные стили */
    .separator {
        height: 1px;
        background: linear-gradient(90deg, transparent, var(--primary-green), transparent);
        margin: 40px 0;
        opacity: 0.5;
    }

    /* Адаптивность */
    @media (max-width: 768px) {
        .tour-title {
            font-size: 2.5rem;
        }

        .tour-meta {
            flex-direction: column;
            align-items: flex-start;
            gap: 15px;
        }

        .inclusions-section {
            grid-template-columns: 1fr;
        }

        .thumbnail-grid {
            grid-template-columns: repeat(2, 1fr);
        }

        .main-image-container {
            height: 300px;
        }
    }

    /* Счётчик участников */
    .participants-counter {
        display: flex;
        align-items: center;
        gap: 10px;
        color: var(--gray);
        font-size: 0.9rem;
        margin-top: 15px;
    }

    .counter-dots {
        display: flex;
        gap: 5px;
    }

    .dot {
        width: 8px;
        height: 8px;
        border-radius: 50%;
        background: var(--light-green);
        animation: pulse 2s infinite;
    }

    .dot:nth-child(2) { animation-delay: 0.2s; }
    .dot:nth-child(3) { animation-delay: 0.4s; }

    @keyframes pulse {
        0%, 100% { opacity: 0.3; }
        50% { opacity: 1; background: var(--primary-green); }
    }
</style>

<div class="tour-detail-page">
    <div class="container">
        <!-- Кнопка назад -->
        <a href="<?= Url::to(['/site/catalog']) ?>" class="back-button reveal">
            Назад к каталогу
        </a>

        <!-- Заголовок тура -->
        <div class="tour-header reveal">
            <h1 class="tour-title"><?= Html::encode($tour->title) ?></h1>
            <div class="tour-meta">
                <div class="tour-price-tag"><?= Html::encode($tour->price) ?></div>
                <div class="tour-duration">
                </div>
                <div class="tour-difficulty">
                </div>
            </div>
        </div>

        <!-- Основной контент -->
        <div class="tour-content">
            <div class="main-content">
                <!-- Галерея -->
                <?php if ($tour->image): ?>
                    <div class="tour-gallery reveal">
                        <div class="main-image-container">
                            <img src="<?= Url::to(['/images/' . $tour->image]) ?>"
                                 class="main-image"
                                 alt="<?= Html::encode($tour->title) ?>"
                                 id="mainImage">
                            <div class="image-badge">Рекомендуем</div>
                        </div>

                    </div>
                <?php endif; ?>

                <!-- Описание -->
                <div class="info-section reveal">
                    <h2 class="section-title">Описание тура</h2>
                    <div class="description-text">
                        <?= nl2br(Html::encode($tour->description)) ?>
                    </div>
                    <div class="participants-counter">
                        <div class="counter-dots">
                            <div class="dot"></div>
                            <div class="dot"></div>
                            <div class="dot"></div>
                        </div>
                    </div>
                </div>


                <!-- Включения/Исключения -->
                <div class="inclusions-section reveal">
                    <div class="inclusions-card">
                        <h4><span>✅</span> Что включено</h4>
                        <ul class="inclusions-list included">
                            <li>Трансфер от/до точки сбора</li>
                            <li>Услуги профессионального гида</li>
                            <li>Питание по программе</li>
                            <li>Проживание в палаточном лагере</li>
                            <li>Туристическое снаряжение</li>
                        </ul>
                    </div>
                    <div class="inclusions-card">
                        <h4><span>❌</span> Что не включено</h4>
                        <ul class="inclusions-list excluded">
                            <li>Личные расходы</li>
                            <li>Страховка от несчастного случая</li>
                            <li>Аренда личного снаряжения</li>
                            <li>Дополнительные экскурсии</li>
                        </ul>
                    </div>
                </div>

                <!-- FAQ -->
                <div class="faq-section reveal">
                    <h2 class="section-title">Частые вопросы</h2>
                    <div class="faq-item">
                        <div class="faq-question">Какая физическая подготовка требуется?</div>
                        <div class="faq-answer">
                            Тур рассчитан на людей со средней физической подготовкой. Маршрут включает пешие переходы до 15 км в день.
                        </div>
                    </div>
                    <div class="faq-item">
                        <div class="faq-question">Что взять с собой?</div>
                        <div class="faq-answer">
                            Удобная обувь для треккинга, теплая одежда, дождевик, личные вещи и хорошее настроение!
                        </div>
                    </div>
                    <div class="faq-item">
                        <div class="faq-question">Можно ли с детьми?</div>
                        <div class="faq-answer">
                            Дети от 12 лет допускаются в сопровождении родителей. Для детей младше - индивидуальные условия.
                        </div>
                    </div>
                </div>
            </div>

            <!-- Боковая панель бронирования -->
            <div class="sidebar">
                <div class="booking-card reveal">
                    <h3>Забронировать тур</h3>
                    <div class="booking-price"><?= Html::encode($tour->price) ?></div>

                    <ul class="booking-features">
                        <li>Безопасная оплата онлайн</li>
                    </ul>

                    <?php if (!Yii::$app->user->isGuest): ?>
                        <?= Html::a('Забронировать сейчас',
                            ['/site/booking', 'id' => $tour->id],
                            ['class' => 'booking-button']
                        ) ?>
                    <?php else: ?>
                        <div class="login-prompt">
                            <p>Для бронирования необходимо</p>
                            <?= Html::a('войти в систему', ['/site/login'], ['class' => 'btn-link']) ?>
                            <p style="margin-top: 10px; font-size: 0.9em; color: var(--gray);">
                                или <?= Html::a('зарегистрироваться', ['/site/register']) ?>
                            </p>
                        </div>
                    <?php endif; ?>

                    <div class="separator"></div>

                    <div style="text-align: center; color: var(--gray); font-size: 0.9rem;">
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<script>
    document.addEventListener('DOMContentLoaded', function() {
        // Анимация появления
        const reveals = document.querySelectorAll('.reveal');

        function reveal() {
            reveals.forEach(element => {
                const windowHeight = window.innerHeight;
                const elementTop = element.getBoundingClientRect().top;
                const elementVisible = 100;

                if (elementTop < windowHeight - elementVisible) {
                    element.classList.add('active');
                }
            });
        }

        reveal();
        window.addEventListener('scroll', reveal);

        // Галерея изображений
        function changeImage(src) {
            document.getElementById('mainImage').src = src;
            document.querySelectorAll('.thumbnail').forEach(thumb => {
                thumb.classList.remove('active');
            });
            event.target.classList.add('active');
        }

        // FAQ аккордеон
        const faqQuestions = document.querySelectorAll('.faq-question');
        faqQuestions.forEach(question => {
            question.addEventListener('click', function() {
                const answer = this.nextElementSibling;
                const isActive = this.classList.contains('active');

                // Закрываем все открытые ответы
                document.querySelectorAll('.faq-answer.active').forEach(item => {
                    item.classList.remove('active');
                    item.previousElementSibling.classList.remove('active');
                });

                // Если текущий не был активен - открываем
                if (!isActive) {
                    this.classList.add('active');
                    answer.classList.add('active');
                }
            });
        });

        // Анимация бронирования
        const bookingButton = document.querySelector('.booking-button');
        if (bookingButton) {
            bookingButton.addEventListener('mouseenter', function() {
                this.style.transform = 'translateY(-5px) scale(1.02)';
            });

            bookingButton.addEventListener('mouseleave', function() {
                this.style.transform = 'translateY(0) scale(1)';
            });
        }

        // Плавный скролл к секциям
        document.querySelectorAll('a[href^="#"]').forEach(anchor => {
            anchor.addEventListener('click', function(e) {
                e.preventDefault();
                const targetId = this.getAttribute('href');
                if (targetId !== '#') {
                    const target = document.querySelector(targetId);
                    if (target) {
                        target.scrollIntoView({
                            behavior: 'smooth',
                            block: 'start'
                        });
                    }
                }
            });
        });

        // Счетчик участников
        function updateCounter() {
            const dots = document.querySelectorAll('.dot');
            let activeIndex = 0;

            setInterval(() => {
                dots.forEach(dot => dot.style.background = 'var(--light-green)');
                dots[activeIndex].style.background = 'var(--primary-green)';
                activeIndex = (activeIndex + 1) % dots.length;
            }, 2000);
        }

        updateCounter();
    });

    // Параллакс эффект для заголовка
    window.addEventListener('scroll', function() {
        const scrolled = window.pageYOffset;
        const tourHeader = document.querySelector('.tour-header');
        if (tourHeader) {
            tourHeader.style.transform = `translateY(${scrolled * 0.1}px)`;
        }
    });
</script>