<?php
use yii\helpers\Html;
use yii\widgets\ActiveForm;
use yii\helpers\Url;

$this->title = 'Мои заявки | Weekend Tours';
?>

<style>
    :root {
        --primary-green: #4CAF7D;
        --light-green: #E8F5E9;
        --accent-green: #81C784;
        --dark-green: #388E3C;
        --white: #FFFFFF;
        --gray-light: #F5F5F5;
        --gray: #757575;
        --gray-dark: #424242;
        --warning: #FF9800;
        --success: #4CAF50;
        --info: #2196F3;
        --error: #f44336;
    }

    .bookings-page {
        min-height: 100vh;
        background: linear-gradient(135deg, var(--light-green) 0%, var(--white) 100%);
        padding: 40px 0;
        position: relative;
        overflow: hidden;
    }

    /* Анимированный фон */
    .bookings-background {
        position: absolute;
        top: 0;
        left: 0;
        width: 100%;
        height: 100%;
        z-index: 0;
        opacity: 0.05;
    }

    .bookings-shape {
        position: absolute;
        border-radius: 50%;
        background: var(--primary-green);
        filter: blur(80px);
        animation: float 25s infinite ease-in-out;
    }

    .bookings-shape:nth-child(1) {
        width: 300px;
        height: 300px;
        top: 10%;
        right: 10%;
        animation-delay: 0s;
    }

    .bookings-shape:nth-child(2) {
        width: 200px;
        height: 200px;
        bottom: 20%;
        left: 5%;
        animation-delay: -10s;
    }

    @keyframes float {
        0%, 100% {
            transform: translate(0, 0) scale(1);
        }
        33% {
            transform: translate(20px, -30px) scale(1.1);
        }
        66% {
            transform: translate(-15px, 20px) scale(0.9);
        }
    }

    /* Основной контейнер */
    .bookings-container {
        position: relative;
        z-index: 1;
        max-width: 1200px;
        margin: 0 auto;
    }

    /* Заголовок */
    .bookings-header {
        text-align: center;
        margin-bottom: 50px;
        opacity: 0;
        transform: translateY(30px);
        animation: fadeInUp 0.8s ease forwards;
    }

    .bookings-title {
        font-size: 3rem;
        font-weight: 800;
        background: linear-gradient(45deg, var(--dark-green), var(--primary-green));
        -webkit-background-clip: text;
        -webkit-text-fill-color: transparent;
        margin-bottom: 15px;
    }

    .bookings-subtitle {
        font-size: 1.2rem;
        color: var(--gray);
        max-width: 600px;
        margin: 0 auto;
    }

    /* Уведомления */
    .notification {
        padding: 20px 25px;
        border-radius: 15px;
        margin-bottom: 30px;
        display: flex;
        align-items: center;
        gap: 15px;
        opacity: 0;
        transform: translateY(30px);
        animation: fadeInUp 0.8s ease 0.2s forwards;
        box-shadow: 0 10px 25px rgba(76, 175, 125, 0.1);
    }

    .notification.success {
        background: linear-gradient(45deg, rgba(76, 175, 125, 0.1), rgba(129, 199, 132, 0.1));
        border-left: 4px solid var(--success);
        color: var(--dark-green);
    }

    .notification-icon {
        font-size: 1.5rem;
        flex-shrink: 0;
    }

    .notification-content {
        flex-grow: 1;
    }

    .notification-close {
        background: none;
        border: none;
        font-size: 1.2rem;
        cursor: pointer;
        color: var(--gray);
        transition: color 0.3s ease;
    }

    .notification-close:hover {
        color: var(--dark-green);
    }

    /* Таблица заявок */
    .bookings-table-container {
        background: var(--white);
        border-radius: 20px;
        overflow: hidden;
        box-shadow: 0 15px 40px rgba(76, 175, 125, 0.1);
        margin-bottom: 50px;
        opacity: 0;
        transform: translateY(30px);
        animation: fadeInUp 0.8s ease 0.4s forwards;
    }

    .bookings-table {
        width: 100%;
        border-collapse: collapse;
    }

    .bookings-table thead {
        background: linear-gradient(45deg, var(--primary-green), var(--accent-green));
    }

    .bookings-table th {
        padding: 25px 20px;
        color: var(--white);
        font-weight: 600;
        text-align: left;
        font-size: 1.1rem;
        position: relative;
    }

    .bookings-table th::after {
        content: '';
        position: absolute;
        right: 0;
        top: 25%;
        height: 50%;
        width: 1px;
        background: rgba(255, 255, 255, 0.2);
    }

    .bookings-table th:last-child::after {
        display: none;
    }

    .bookings-table tbody tr {
        border-bottom: 2px solid var(--light-green);
        transition: all 0.3s ease;
    }

    .bookings-table tbody tr:hover {
        background: rgba(76, 175, 125, 0.03);
        transform: translateX(5px);
    }

    .bookings-table tbody tr:last-child {
        border-bottom: none;
    }

    .bookings-table td {
        padding: 25px 20px;
        color: var(--gray-dark);
    }

    /* Статусы заявок */
    .status-badge {
        display: inline-flex;
        align-items: center;
        gap: 8px;
        padding: 10px 20px;
        border-radius: 50px;
        font-weight: 600;
        font-size: 0.9rem;
        white-space: nowrap;
    }

    .status-pending {
        background: rgba(255, 152, 0, 0.1);
        color: var(--warning);
        border: 1px solid rgba(255, 152, 0, 0.2);
    }

    .status-accepted {
        background: rgba(76, 175, 125, 0.1);
        color: var(--success);
        border: 1px solid rgba(76, 175, 125, 0.2);
    }

    .status-cancelled {
        background: rgba(244, 67, 54, 0.1);
        color: var(--error);
        border: 1px solid rgba(244, 67, 54, 0.2);
    }

    .status-processing {
        background: rgba(33, 150, 243, 0.1);
        color: var(--info);
        border: 1px solid rgba(33, 150, 243, 0.2);
    }

    /* Секция отзывов */
    .reviews-section {
        margin-top: 30px;
        padding: 25px;
        background: rgba(76, 175, 125, 0.03);
        border-radius: 15px;
        border: 2px dashed var(--light-green);
        transition: all 0.3s ease;
    }

    .reviews-section:hover {
        border-color: var(--primary-green);
        background: rgba(76, 175, 125, 0.05);
        transform: translateY(-5px);
    }

    .reviews-title {
        color: var(--dark-green);
        font-size: 1.2rem;
        margin-bottom: 20px;
        display: flex;
        align-items: center;
        gap: 10px;
    }

    /* Форма отзыва */
    .review-form {
        background: var(--white);
        padding: 25px;
        border-radius: 15px;
        box-shadow: 0 10px 25px rgba(76, 175, 125, 0.1);
        margin-bottom: 25px;
        transition: all 0.3s ease;
    }

    .review-form:hover {
        box-shadow: 0 15px 35px rgba(76, 175, 125, 0.15);
    }

    .form-row {
        display: grid;
        grid-template-columns: 1fr 1fr;
        gap: 20px;
        margin-bottom: 20px;
    }

    @media (max-width: 768px) {
        .form-row {
            grid-template-columns: 1fr;
        }
    }

    .form-group {
        margin-bottom: 20px;
    }

    .form-label {
        display: block;
        margin-bottom: 10px;
        color: var(--dark-green);
        font-weight: 600;
        font-size: 0.95rem;
    }

    .form-textarea {
        width: 100%;
        padding: 15px;
        border: 2px solid var(--light-green);
        border-radius: 10px;
        font-size: 1rem;
        color: var(--gray-dark);
        background: var(--white);
        transition: all 0.3s ease;
        outline: none;
        font-family: inherit;
        resize: vertical;
        min-height: 120px;
    }

    .form-textarea:focus {
        border-color: var(--primary-green);
        box-shadow: 0 0 0 3px rgba(76, 175, 125, 0.1);
    }

    /* Рейтинг */
    .rating-container {
        display: flex;
        align-items: center;
        gap: 10px;
    }

    .rating-stars {
        display: flex;
        gap: 5px;
        direction: rtl;
    }

    .rating-star {
        font-size: 2rem;
        color: #e0e0e0;
        cursor: pointer;
        transition: all 0.2s ease;
        line-height: 1;
    }

    .rating-star:hover,
    .rating-star:hover ~ .rating-star {
        color: #ffd700;
    }

    .rating-input {
        display: none;
    }

    .rating-input:checked ~ .rating-star {
        color: #ffd700;
    }

    .rating-value {
        font-weight: 600;
        color: var(--dark-green);
        min-width: 30px;
    }

    /* Кнопки */
    .submit-button {
        display: inline-flex;
        align-items: center;
        gap: 10px;
        padding: 15px 30px;
        background: linear-gradient(45deg, var(--primary-green), var(--accent-green));
        color: var(--white);
        text-decoration: none;
        border-radius: 12px;
        border: none;
        font-size: 1rem;
        font-weight: 600;
        cursor: pointer;
        transition: all 0.3s ease;
    }

    .submit-button:hover {
        transform: translateY(-3px);
        box-shadow: 0 10px 25px rgba(76, 175, 125, 0.3);
    }

    .submit-button::after {
        content: '→';
        transition: transform 0.3s ease;
    }

    .submit-button:hover::after {
        transform: translateX(5px);
    }

    /* Существующие отзывы */
    .existing-reviews {
        margin-top: 30px;
    }

    .existing-reviews h4 {
        color: var(--dark-green);
        margin-bottom: 15px;
        display: flex;
        align-items: center;
        gap: 10px;
    }

    .review-list {
        list-style: none;
        padding: 0;
    }

    .review-item {
        background: var(--white);
        padding: 20px;
        border-radius: 12px;
        margin-bottom: 15px;
        box-shadow: 0 5px 15px rgba(76, 175, 125, 0.05);
        border-left: 4px solid var(--primary-green);
        transition: all 0.3s ease;
    }

    .review-item:hover {
        transform: translateX(5px);
        box-shadow: 0 8px 25px rgba(76, 175, 125, 0.1);
    }

    .review-content {
        color: var(--gray-dark);
        line-height: 1.6;
        margin-bottom: 10px;
    }

    .review-meta {
        display: flex;
        justify-content: space-between;
        align-items: center;
        color: var(--gray);
        font-size: 0.9rem;
    }

    .review-rating {
        display: flex;
        gap: 2px;
    }

    .review-rating span {
        color: #ffd700;
        font-size: 1.2rem;
    }

    /* Пустое состояние */
    .empty-state {
        text-align: center;
        padding: 80px 20px;
        opacity: 0;
        transform: translateY(30px);
        animation: fadeInUp 0.8s ease 0.6s forwards;
    }

    .empty-icon {
        font-size: 4rem;
        margin-bottom: 20px;
        color: var(--primary-green);
        opacity: 0.5;
    }

    .empty-title {
        color: var(--dark-green);
        font-size: 1.8rem;
        margin-bottom: 15px;
    }

    .empty-description {
        color: var(--gray);
        font-size: 1.1rem;
        margin-bottom: 30px;
        max-width: 500px;
        margin-left: auto;
        margin-right: auto;
    }

    .explore-button {
        display: inline-flex;
        align-items: center;
        gap: 10px;
        padding: 15px 40px;
        background: var(--white);
        color: var(--dark-green);
        text-decoration: none;
        border-radius: 12px;
        font-weight: 600;
        border: 2px solid var(--light-green);
        transition: all 0.3s ease;
    }

    .explore-button:hover {
        background: var(--primary-green);
        color: var(--white);
        border-color: var(--primary-green);
        transform: translateY(-3px);
        box-shadow: 0 10px 20px rgba(76, 175, 125, 0.2);
    }

    /* Анимации */
    @keyframes fadeInUp {
        from {
            opacity: 0;
            transform: translateY(40px);
        }
        to {
            opacity: 1;
            transform: translateY(0);
        }
    }

    @keyframes slideInRight {
        from {
            opacity: 0;
            transform: translateX(-20px);
        }
        to {
            opacity: 1;
            transform: translateX(0);
        }
    }

    /* Кнопка назад */
    .back-button {
        display: inline-flex;
        align-items: center;
        gap: 10px;
        padding: 12px 25px;
        background: var(--white);
        color: var(--gray-dark);
        text-decoration: none;
        border-radius: 50px;
        font-weight: 500;
        margin-bottom: 30px;
        transition: all 0.3s ease;
        box-shadow: 0 5px 15px rgba(76, 175, 125, 0.1);
    }

    .back-button:hover {
        background: var(--light-green);
        color: var(--dark-green);
        transform: translateX(-5px);
    }

    .back-button::before {
        content: '←';
        transition: transform 0.3s ease;
    }

    .back-button:hover::before {
        transform: translateX(-5px);
    }

    /* Фильтры */
    .bookings-filters {
        display: flex;
        gap: 15px;
        margin-bottom: 30px;
        flex-wrap: wrap;
        opacity: 0;
        transform: translateY(30px);
        animation: fadeInUp 0.8s ease 0.3s forwards;
    }

    .filter-button {
        padding: 12px 25px;
        background: var(--white);
        color: var(--gray-dark);
        border: 2px solid var(--light-green);
        border-radius: 50px;
        font-weight: 500;
        cursor: pointer;
        transition: all 0.3s ease;
    }

    .filter-button:hover {
        background: var(--light-green);
        color: var(--dark-green);
        transform: translateY(-2px);
    }

    .filter-button.active {
        background: var(--primary-green);
        color: var(--white);
        border-color: var(--primary-green);
    }

    /* Адаптивность */
    @media (max-width: 992px) {
        .bookings-table {
            display: block;
            overflow-x: auto;
        }

        .bookings-table th,
        .bookings-table td {
            white-space: nowrap;
            min-width: 150px;
        }
    }

    @media (max-width: 576px) {
        .bookings-title {
            font-size: 2.2rem;
        }

        .bookings-table td {
            padding: 15px 10px;
        }

        .reviews-section {
            padding: 15px;
        }
    }

    /* Индикатор загрузки */
    .loading-indicator {
        display: flex;
        align-items: center;
        justify-content: center;
        padding: 40px;
    }

    .loading-spinner {
        width: 40px;
        height: 40px;
        border: 3px solid var(--light-green);
        border-top-color: var(--primary-green);
        border-radius: 50%;
        animation: spin 1s linear infinite;
    }

    @keyframes spin {
        to { transform: rotate(360deg); }
    }

    /* Кастомный скроллбар */
    ::-webkit-scrollbar {
        width: 8px;
        height: 8px;
    }

    ::-webkit-scrollbar-track {
        background: var(--light-green);
        border-radius: 4px;
    }

    ::-webkit-scrollbar-thumb {
        background: var(--primary-green);
        border-radius: 4px;
    }

    ::-webkit-scrollbar-thumb:hover {
        background: var(--dark-green);
    }
</style>

<div class="bookings-page">
    <!-- Анимированный фон -->
    <div class="bookings-background">
        <div class="bookings-shape"></div>
        <div class="bookings-shape"></div>
    </div>

    <div class="container bookings-container">
        <!-- Кнопка назад -->
        <a href="<?= Url::to(['/site/index']) ?>" class="back-button reveal">
            Вернуться на главную
        </a>

        <!-- Заголовок -->
        <div class="bookings-header reveal">
            <h1 class="bookings-title">Мои заявки</h1>
            <p class="bookings-subtitle">Управляйте своими бронированиями и оставляйте отзывы</p>
        </div>

        <!-- Уведомления -->
        <?php if(Yii::$app->session->hasFlash('success')): ?>
            <div class="notification success reveal">
                <span class="notification-icon">✅</span>
                <div class="notification-content">
                    <?= Yii::$app->session->getFlash('success') ?>
                </div>
                <button class="notification-close" onclick="this.parentElement.remove()">×</button>
            </div>
        <?php endif; ?>


        <?php if (!empty($bookings)): ?>
            <!-- Таблица заявок -->
            <div class="bookings-table-container reveal">
                <table class="bookings-table">
                    <thead>
                    <tr>
                        <th>Тур</th>
                        <th>Дата</th>
                        <th>Участники</th>
                        <th>Статус</th>
                        <th>Отзыв</th>
                    </tr>
                    </thead>
                    <tbody>
                    <?php foreach ($bookings as $index => $b): ?>
                        <tr class="booking-row" data-status="<?= strtolower(preg_replace('/[^a-zA-Zа-яА-Я]/u', '', $b->status)) ?>">
                            <td>
                                <div class="tour-info">
                                    <strong style="color: var(--dark-green); display: block; margin-bottom: 5px;">
                                        <?= Html::encode($b->tour->title) ?>
                                    </strong>
                                    <small style="color: var(--gray);">
                                        <?= Html::encode($b->tour->price) ?> ₽ за человека
                                    </small>
                                </div>
                            </td>
                            <td>
                                <div class="date-info">
                                    <div style="font-weight: 600; color: var(--dark-green);">
                                        <?= Html::encode(date('d.m.Y', strtotime($b->tour_date))) ?>
                                    </div>
                                    <small style="color: var(--gray);">
                                        <?= Html::encode(date('H:i', strtotime($b->tour_date))) ?>
                                    </small>
                                </div>
                            </td>
                            <td>
                                <div class="persons-info">
                                        <span style="font-weight: 600; color: var(--dark-green); font-size: 1.2rem;">
                                            <?= Html::encode($b->persons) ?>
                                        </span>
                                    <span style="color: var(--gray); margin-left: 5px;">человек</span>
                                </div>
                            </td>
                            <td>
                                <?php
                                $statusClass = 'status-processing';
                                $statusText = $b->status;
                                $statusIcon = '⏳';

                                if (strpos($b->status, 'Принята') !== false) {
                                    $statusClass = 'status-accepted';
                                    $statusIcon = '✅';
                                } elseif (strpos($b->status, 'Отмен') !== false) {
                                    $statusClass = 'status-cancelled';
                                    $statusIcon = '❌';
                                } elseif (strpos($b->status, 'Ожидание') !== false) {
                                    $statusClass = 'status-pending';
                                    $statusIcon = '⏳';
                                }
                                ?>
                                <div class="status-badge <?= $statusClass ?>">
                                    <span><?= $statusIcon ?></span>
                                    <span><?= Html::encode($statusText) ?></span>
                                </div>
                            </td>
                            <td>
                                <?php if ($b->status == 'Заявка принята'): ?>
                                    <!-- Форма для добавления нового отзыва -->
                                    <div class="reviews-section">
                                        <div class="reviews-title">
                                            <span>💭</span>
                                            Оставьте отзыв
                                        </div>

                                        <?php $form = ActiveForm::begin([
                                            'action' => ['site/my-bookings'],
                                            'options' => [
                                                'class' => 'review-form',
                                                'id' => 'review-form-' . $b->id
                                            ]
                                        ]); ?>

                                        <?= $form->field($review, 'tour_id')->hiddenInput(['value'=>$b->tour_id])->label(false) ?>
                                        <?= $form->field($review, 'user_id')->hiddenInput(['value'=>Yii::$app->user->id])->label(false) ?>

                                        <div class="form-row">
                                            <div class="form-group" style="grid-column: 1 / -1;">
                                                <label class="form-label">Ваш отзыв</label>
                                                <?= $form->field($review, 'text', [
                                                    'template' => '{input}{error}',
                                                    'options' => ['class' => '']
                                                ])->textarea([
                                                    'rows' => 3,
                                                    'class' => 'form-textarea',
                                                    'placeholder' => 'Поделитесь своими впечатлениями о туре...'
                                                ])->label(false) ?>
                                            </div>

                                            <div class="form-group">
                                                <label class="form-label">Оценка</label>
                                                <div class="rating-container">
                                                    <div class="rating-stars">
                                                        <!-- Скрытое поле, именно его читает Yii -->
                                                        <?= $form->field($review, 'rating')
                                                            ->hiddenInput(['id' => 'rating-input-' . $b->id])
                                                            ->label(false) ?>

                                                        <div class="rating-stars" data-booking="<?= $b->id ?>">
                                                            <?php for ($i = 5; $i >= 1; $i--): ?>
                                                                <span class="rating-star" data-value="<?= $i ?>">★</span>
                                                            <?php endfor; ?>
                                                        </div>

                                                        <span class="rating-value" id="rating-value-<?= $b->id ?>">0</span>

                                                    </div>

                                            <div class="form-group" style="display: flex; align-items: flex-end;">
                                                <button type="submit" class="submit-button">
                                                    <span>Отправить отзыв</span>
                                                </button>
                                            </div>
                                        </div>

                                        <?php ActiveForm::end(); ?>

                                        <!-- Список уже оставленных отзывов -->
                                        <?php if ($b->reviews): ?>
                                            <div class="existing-reviews">
                                                <h4>
                                                    <span>📝</span>
                                                    Ваши отзывы
                                                </h4>
                                                <ul class="review-list">
                                                    <?php foreach ($b->reviews as $r): ?>
                                                        <li class="review-item">
                                                            <div class="review-content">
                                                                <?= Html::encode($r->text) ?>
                                                            </div>
                                                            <div class="review-meta">
                                                                <span><?= date('d.m.Y', strtotime($r->created_at)) ?></span>
                                                                <div class="review-rating">
                                                                    <?= str_repeat('★', $r->rating) ?>
                                                                </div>
                                                            </div>
                                                        </li>
                                                    <?php endforeach; ?>
                                                </ul>
                                            </div>
                                        <?php endif; ?>
                                    </div>
                                <?php else: ?>
                                    <div style="color: var(--gray); font-style: italic; text-align: center;">
                                        Отзыв доступен после подтверждения заявки
                                    </div>
                                <?php endif; ?>
                            </td>
                        </tr>
                    <?php endforeach; ?>
                    </tbody>
                </table>
            </div>
        <?php else: ?>
            <!-- Пустое состояние -->
            <div class="empty-state reveal">
                <div class="empty-icon">📋</div>
                <h2 class="empty-title">У вас пока нет заявок</h2>
                <p class="empty-description">
                    Отправьтесь в незабываемое путешествие по Уралу!
                    Выберите подходящий тур и оформите бронирование.
                </p>
                <a href="<?= Url::to(['/site/catalog']) ?>" class="explore-button">
                    <span>Посмотреть туры</span>
                    <span>→</span>
                </a>
            </div>
        <?php endif; ?>


<script>
    document.addEventListener('DOMContentLoaded', function() {
        // Инициализация анимаций
        const reveals = document.querySelectorAll('.reveal');

        function reveal() {
            reveals.forEach(element => {
                const windowHeight = window.innerHeight;
                const elementTop = element.getBoundingClientRect().top;
                const elementVisible = 100;

                if (elementTop < windowHeight - elementVisible) {
                    element.classList.add('active');
                }
            });
        }

        reveal();
        window.addEventListener('scroll', reveal);

        // Фильтрация заявок
        window.filterBookings = function(status) {
            const buttons = document.querySelectorAll('.filter-button');
            const rows = document.querySelectorAll('.booking-row');

            // Обновление активной кнопки
            buttons.forEach(btn => {
                btn.classList.remove('active');
                if (btn.textContent.toLowerCase().includes(status)) {
                    btn.classList.add('active');
                }
            });

            // Фильтрация строк
            rows.forEach(row => {
                if (status === 'all' || row.dataset.status === status) {
                    row.style.display = '';
                    setTimeout(() => {
                        row.style.opacity = '1';
                        row.style.transform = 'translateX(0)';
                    }, 10);
                } else {
                    row.style.opacity = '0';
                    row.style.transform = 'translateX(-20px)';
                    setTimeout(() => {
                        row.style.display = 'none';
                    }, 300);
                }
            });
        };

        // Инициализация звезд рейтинга
        document.querySelectorAll('.rating-stars').forEach(starsContainer => {
            const stars = starsContainer.querySelectorAll('.rating-star');
            const ratingValue = starsContainer.parentElement.querySelector('.rating-value');
            const hiddenInput = document.getElementById('rating-input-' + starsContainer.closest('.reviews-section').parentElement.parentElement.id.split('-').pop());

            stars.forEach(star => {
                star.addEventListener('click', function() {
                    const rating = this.previousElementSibling.value;
                    ratingValue.textContent = rating;
                    if (hiddenInput) {
                        hiddenInput.value = rating;
                    }

                    // Подсветка выбранных звезд
                    stars.forEach(s => {
                        if (parseInt(s.previousElementSibling.value) <= rating) {
                            s.style.color = '#ffd700';
                        } else {
                            s.style.color = '#e0e0e0';
                        }
                    });
                });

                star.addEventListener('mouseover', function() {
                    const hoverRating = this.previousElementSibling.value;
                    stars.forEach(s => {
                        if (parseInt(s.previousElementSibling.value) <= hoverRating) {
                            s.style.color = '#ffd700';
                        } else {
                            s.style.color = '#e0e0e0';
                        }
                    });
                });

                star.addEventListener('mouseout', function() {
                    const currentRating = ratingValue.textContent;
                    stars.forEach(s => {
                        if (parseInt(s.previousElementSibling.value) <= currentRating) {
                            s.style.color = '#ffd700';
                        } else {
                            s.style.color = '#e0e0e0';
                        }
                    });
                });
            });
        });

        // Анимация отправки формы
        document.querySelectorAll('.review-form').forEach(form => {
            form.addEventListener('submit', function(e) {
                const submitBtn = this.querySelector('.submit-button');
                const originalText = submitBtn.innerHTML;

                submitBtn.innerHTML = '<span>Отправка...</span>';
                submitBtn.disabled = true;

                // Анимация загрузки
                submitBtn.style.position = 'relative';
                submitBtn.style.overflow = 'hidden';

                const loader = document.createElement('div');
                loader.style.position = 'absolute';
                loader.style.top = '0';
                loader.style.left = '-100%';
                loader.style.width = '100%';
                loader.style.height = '100%';
                loader.style.background = 'linear-gradient(90deg, transparent, rgba(255,255,255,0.3), transparent)';
                loader.style.animation = 'loading 1s infinite';
                submitBtn.appendChild(loader);

                // В реальном приложении удалить setTimeout
                setTimeout(() => {
                    submitBtn.innerHTML = originalText;
                    submitBtn.disabled = false;
                    loader.remove();
                }, 2000);
            });
        });
        document.querySelectorAll('.rating-stars').forEach(container => {
            const bookingId = container.dataset.booking;
            const stars = container.querySelectorAll('.rating-star');
            const hiddenInput = document.getElementById('rating-input-' + bookingId);
            const valueLabel = document.getElementById('rating-value-' + bookingId);

            stars.forEach(star => {
                star.addEventListener('click', () => {
                    const rating = star.dataset.value;

                    hiddenInput.value = rating;
                    valueLabel.textContent = rating;

                    stars.forEach(s => {
                        s.style.color =
                            s.dataset.value <= rating ? '#ffd700' : '#e0e0e0';
                    });
                });
            });
        });

        // Закрытие уведомлений
        document.querySelectorAll('.notification-close').forEach(btn => {
            btn.addEventListener('click', function() {
                this.closest('.notification').style.opacity = '0';
                this.closest('.notification').style.transform = 'translateX(100px)';
                setTimeout(() => {
                    this.closest('.notification').remove();
                }, 300);
            });
        });

        // Автоматическое скрытие уведомлений через 5 секунд
        setTimeout(() => {
            document.querySelectorAll('.notification').forEach(notification => {
                notification.style.opacity = '0';
                notification.style.transform = 'translateX(100px)';
                setTimeout(() => {
                    notification.remove();
                }, 300);
            });
        }, 5000);

        // Параллакс эффект для фона
        window.addEventListener('scroll', function() {
            const scrolled = window.pageYOffset;
            const background = document.querySelector('.bookings-background');
            if (background) {
                background.style.transform = `translateY(${scrolled * 0.03}px)`;
            }
        });

        // Анимация при наведении на строки таблицы
        document.querySelectorAll('.booking-row').forEach(row => {
            row.addEventListener('mouseenter', function() {
                this.style.transition = 'all 0.3s ease';
            });

            row.addEventListener('mouseleave', function() {
                setTimeout(() => {
                    this.style.transform = 'translateX(0)';
                }, 10);
            });
        });

        // Стили для анимации загрузки
        const style = document.createElement('style');
        style.textContent = `
        @keyframes loading {
            0% { left: -100%; }
            100% { left: 100%; }
        }
    `;
        document.head.appendChild(style);
    });

    // Экспорт функций для глобального доступа
    window.changeFilter = function(filter) {
        filterBookings(filter);
    };
</script>