<?php
use yii\widgets\ActiveForm;
use yii\helpers\Html;

$this->title = 'Вход';
?>

<style>
    :root {
        --primary-green: #4CAF7D;
        --light-green: #E8F5E9;
        --accent-green: #81C784;
        --dark-green: #388E3C;
        --white: #FFFFFF;
        --gray-light: #F5F5F5;
        --gray: #757575;
        --gray-dark: #424242;
        --warning: #FF9800;
        --error: #f44336;
    }

    .login-page {
        min-height: 100vh;
        background: linear-gradient(135deg, var(--light-green) 0%, var(--white) 100%);
        padding: 40px 0;
        position: relative;
        overflow: hidden;
    }

    /* Анимированный фон */
    .login-background {
        position: absolute;
        top: 0;
        left: 0;
        width: 100%;
        height: 100%;
        z-index: 0;
        opacity: 0.1;
    }

    .login-shape {
        position: absolute;
        border-radius: 50%;
        background: var(--primary-green);
        filter: blur(60px);
        opacity: 0.3;
        animation: float 20s infinite ease-in-out;
    }

    .login-shape:nth-child(1) {
        width: 400px;
        height: 400px;
        top: -100px;
        right: -100px;
        animation-delay: 0s;
    }

    .login-shape:nth-child(2) {
        width: 300px;
        height: 300px;
        bottom: -50px;
        left: -50px;
        animation-delay: -5s;
    }

    @keyframes float {
        0%, 100% {
            transform: translate(0, 0) rotate(0deg);
        }
        33% {
            transform: translate(30px, 30px) rotate(120deg);
        }
        66% {
            transform: translate(-20px, 40px) rotate(240deg);
        }
    }

    /* Основной контейнер */
    .login-container {
        position: relative;
        z-index: 1;
        max-width: 500px;
        margin: 0 auto;
        padding: 0 20px;
    }

    /* Заголовок */
    .login-header {
        text-align: center;
        margin-bottom: 50px;
        opacity: 0;
        transform: translateY(30px);
        animation: fadeInUp 0.8s ease forwards;
    }

    .login-title {
        font-size: 3rem;
        font-weight: 800;
        background: linear-gradient(45deg, var(--dark-green), var(--primary-green));
        -webkit-background-clip: text;
        -webkit-text-fill-color: transparent;
        margin-bottom: 15px;
    }

    .login-subtitle {
        font-size: 1.2rem;
        color: var(--gray);
        max-width: 600px;
        margin: 0 auto;
    }

    /* Форма */
    .login-form-section {
        opacity: 0;
        transform: translateY(30px);
        animation: fadeInUp 0.8s ease 0.3s forwards;
    }

    .form-card {
        background: var(--white);
        border-radius: 20px;
        padding: 40px;
        box-shadow: 0 15px 40px rgba(76, 175, 125, 0.1);
    }

    /* Поля формы */
    .form-group {
        margin-bottom: 30px;
        position: relative;
    }

    .form-label {
        display: block;
        margin-bottom: 12px;
        color: var(--dark-green);
        font-weight: 600;
        font-size: 1rem;
        display: flex;
        align-items: center;
        gap: 10px;
    }

    .form-label::after {
        content: '*';
        color: var(--error);
        font-size: 1.2rem;
        opacity: 0.7;
    }

    .form-input {
        width: 100%;
        padding: 18px 20px;
        border: 2px solid var(--light-green);
        border-radius: 12px;
        font-size: 1rem;
        color: var(--gray-dark);
        background: var(--white);
        transition: all 0.3s ease;
        outline: none;
        font-family: inherit;
    }

    .form-input:focus {
        border-color: var(--primary-green);
        box-shadow: 0 0 0 4px rgba(76, 175, 125, 0.1);
        transform: translateY(-2px);
    }

    .form-input::placeholder {
        color: var(--gray);
        opacity: 0.6;
    }

    /* Иконки в полях */
    .input-with-icon {
        position: relative;
    }

    .input-icon {
        position: absolute;
        left: 20px;
        top: 50%;
        transform: translateY(-50%);
        font-size: 1.2rem;
        color: var(--gray);
        z-index: 1;
    }

    .input-with-icon .form-input {
        padding-left: 55px;
    }

    /* Кнопка отправки */
    .submit-section {
        margin-top: 40px;
    }

    .submit-button {
        display: flex;
        align-items: center;
        justify-content: center;
        gap: 15px;
        width: 100%;
        padding: 22px;
        background: linear-gradient(45deg, var(--primary-green), var(--accent-green));
        color: var(--white);
        border: none;
        border-radius: 15px;
        font-size: 1.2rem;
        font-weight: 700;
        cursor: pointer;
        transition: all 0.4s ease;
        position: relative;
        overflow: hidden;
    }

    .submit-button::before {
        content: '';
        position: absolute;
        top: 0;
        left: -100%;
        width: 100%;
        height: 100%;
        background: linear-gradient(90deg, transparent, rgba(255,255,255,0.2), transparent);
        transition: left 0.5s ease;
    }

    .submit-button:hover::before {
        left: 100%;
    }

    .submit-button:hover {
        transform: translateY(-5px);
        box-shadow: 0 20px 40px rgba(76, 175, 125, 0.3);
    }

    .submit-button:active {
        transform: translateY(-2px);
    }

    /* Ссылки */
    .login-links {
        margin-top: 30px;
        text-align: center;
        color: var(--gray);
    }

    .login-link {
        color: var(--primary-green);
        text-decoration: none;
        font-weight: 500;
        transition: all 0.3s ease;
        display: inline-flex;
        align-items: center;
        gap: 5px;
    }

    .login-link:hover {
        color: var(--dark-green);
        transform: translateY(-2px);
    }

    .login-link::after {
        content: '→';
        transition: transform 0.3s ease;
    }

    .login-link:hover::after {
        transform: translateX(5px);
    }

    /* Информационные сообщения */
    .login-info {
        display: grid;
        grid-template-columns: repeat(auto-fit, minmax(250px, 1fr));
        gap: 20px;
        margin-top: 40px;
    }

    .info-card {
        background: var(--white);
        border-radius: 15px;
        padding: 25px;
        box-shadow: 0 10px 25px rgba(76, 175, 125, 0.1);
        text-align: center;
        transition: all 0.3s ease;
    }

    .info-card:hover {
        transform: translateY(-5px);
        box-shadow: 0 15px 35px rgba(76, 175, 125, 0.15);
    }

    .info-icon {
        font-size: 2.5rem;
        margin-bottom: 15px;
        display: block;
    }

    .info-card h4 {
        color: var(--dark-green);
        margin-bottom: 10px;
    }

    .info-card p {
        color: var(--gray);
        font-size: 0.9rem;
        line-height: 1.6;
    }

    /* Анимации */
    @keyframes fadeInUp {
        from {
            opacity: 0;
            transform: translateY(40px);
        }
        to {
            opacity: 1;
            transform: translateY(0);
        }
    }

    /* Валидация */
    .form-input.error {
        border-color: var(--error);
        animation: shake 0.5s ease;
    }

    @keyframes shake {
        0%, 100% { transform: translateX(0); }
        25% { transform: translateX(-5px); }
        75% { transform: translateX(5px); }
    }

    .error-message {
        color: var(--error);
        font-size: 0.9rem;
        margin-top: 5px;
        display: flex;
        align-items: center;
        gap: 5px;
    }

    .error-message::before {
        content: '⚠️';
    }

    /* Загрузка */
    .loading-overlay {
        position: fixed;
        top: 0;
        left: 0;
        width: 100%;
        height: 100%;
        background: rgba(255,255,255,0.9);
        display: flex;
        flex-direction: column;
        align-items: center;
        justify-content: center;
        z-index: 1000;
        opacity: 0;
        visibility: hidden;
        transition: all 0.3s ease;
    }

    .loading-overlay.active {
        opacity: 1;
        visibility: visible;
    }

    .loading-spinner {
        width: 50px;
        height: 50px;
        border: 4px solid var(--light-green);
        border-top-color: var(--primary-green);
        border-radius: 50%;
        animation: spin 1s linear infinite;
        margin-bottom: 20px;
    }

    @keyframes spin {
        to { transform: rotate(360deg); }
    }

    /* Кнопка назад */
    .back-button {
        display: inline-flex;
        align-items: center;
        gap: 10px;
        padding: 12px 25px;
        background: var(--white);
        color: var(--gray-dark);
        text-decoration: none;
        border-radius: 50px;
        font-weight: 500;
        margin-bottom: 30px;
        transition: all 0.3s ease;
        box-shadow: 0 5px 15px rgba(76, 175, 125, 0.1);
    }

    .back-button:hover {
        background: var(--light-green);
        color: var(--dark-green);
        transform: translateX(-5px);
    }

    .back-button::before {
        content: '←';
        transition: transform 0.3s ease;
    }

    .back-button:hover::before {
        transform: translateX(-5px);
    }

    /* Адаптивность */
    @media (max-width: 576px) {
        .login-title {
            font-size: 2.2rem;
        }

        .form-card {
            padding: 25px;
        }

        .login-info {
            grid-template-columns: 1fr;
        }
    }

    /* Кастомный скроллбар */
    ::-webkit-scrollbar {
        width: 8px;
    }

    ::-webkit-scrollbar-track {
        background: var(--light-green);
        border-radius: 4px;
    }

    ::-webkit-scrollbar-thumb {
        background: var(--primary-green);
        border-radius: 4px;
    }

    ::-webkit-scrollbar-thumb:hover {
        background: var(--dark-green);
    }

    /* Чекбокс "Запомнить меня" */
    .remember-me {
        display: flex;
        align-items: center;
        gap: 10px;
        margin-top: 20px;
        color: var(--gray-dark);
    }

    .remember-checkbox {
        width: 20px;
        height: 20px;
        border: 2px solid var(--light-green);
        border-radius: 6px;
        cursor: pointer;
        position: relative;
        transition: all 0.3s ease;
    }

    .remember-checkbox:checked {
        background: var(--primary-green);
        border-color: var(--primary-green);
    }

    .remember-checkbox:checked::after {
        content: '✓';
        position: absolute;
        color: var(--white);
        font-size: 14px;
        top: 50%;
        left: 50%;
        transform: translate(-50%, -50%);
    }
</style>

<div class="login-page">
    <!-- Анимированный фон -->
    <div class="login-background">
        <div class="login-shape"></div>
        <div class="login-shape"></div>
    </div>

    <div class="container login-container">
        <!-- Кнопка назад -->


        <!-- Заголовок -->
        <div class="login-header reveal">
            <h1 class="login-title">Вход в систему</h1>
            <p class="login-subtitle">Войдите в свой аккаунт для доступа ко всем возможностям</p>
        </div>

        <!-- Основной контент -->
        <div class="login-form-section reveal">
            <div class="form-card">
                <?php $form = ActiveForm::begin([
                    'id' => 'login-form',
                    'enableClientValidation' => true,
                ]); ?>

                <!-- Email -->
                <div class="form-group">
                    <label class="form-label">
                        <span>📧</span>
                        Электронная почта
                    </label>
                    <div class="input-with-icon">
                        <span class="input-icon">✉️</span>
                        <?= $form->field($model, 'email', [
                            'template' => '{input}{error}',
                        ])->input('email', [
                            'class' => 'form-input',
                            'required' => true,
                            'placeholder' => 'Ваш email'
                        ])->label(false) ?>
                    </div>
                </div>

                <!-- Пароль -->
                <div class="form-group">
                    <label class="form-label">
                        <span>🔒</span>
                        Пароль
                    </label>
                    <div class="input-with-icon">
                        <span class="input-icon">🔑</span>
                        <?= $form->field($model, 'password', [
                            'template' => '{input}{error}',
                        ])->passwordInput([
                            'class' => 'form-input',
                            'required' => true,
                            'placeholder' => 'Ваш пароль'
                        ])->label(false) ?>
                    </div>
                </div>

                <!-- Чекбокс "Запомнить меня" -->
                <div class="remember-me">
                    <input type="checkbox" id="remember-me" class="remember-checkbox" name="LoginForm[rememberMe]" value="1">
                    <label for="remember-me">Запомнить меня</label>
                </div>

                <!-- Кнопка отправки -->
                <div class="submit-section">
                    <button type="submit" class="submit-button">
                        <span>Войти в аккаунт</span>
                    </button>
                </div>

                <?php ActiveForm::end(); ?>

                <!-- Ссылки -->
                <div class="login-links">
                    <p><a href="/site/register" class="login-link">Еще не зарегистрированы? Регистрация</a></p>
                </div>
            </div>


        <!-- Оверлей загрузки -->
        <div class="loading-overlay" id="loadingOverlay">
            <div class="loading-spinner"></div>
            <p style="color: var(--dark-green); font-weight: 600;">Входим в систему...</p>
        </div>
    </div>
</div>

<script>
    document.addEventListener('DOMContentLoaded', function() {
        // Инициализация анимаций
        const reveals = document.querySelectorAll('.reveal');

        function reveal() {
            reveals.forEach(element => {
                const windowHeight = window.innerHeight;
                const elementTop = element.getBoundingClientRect().top;
                const elementVisible = 100;

                if (elementTop < windowHeight - elementVisible) {
                    element.classList.add('active');
                }
            });
        }

        reveal();
        window.addEventListener('scroll', reveal);

        // Валидация формы
        const loginForm = document.getElementById('login-form');
        const loadingOverlay = document.getElementById('loadingOverlay');

        loginForm.addEventListener('submit', function(e) {
            let isValid = true;

            // Проверка обязательных полей
            const requiredFields = loginForm.querySelectorAll('[required]');

            requiredFields.forEach(field => {
                if (!field.value.trim()) {
                    field.classList.add('error');
                    isValid = false;

                    // Анимация ошибки
                    field.style.animation = 'none';
                    setTimeout(() => {
                        field.style.animation = 'shake 0.5s ease';
                    }, 10);
                } else {
                    field.classList.remove('error');
                }
            });

            if (isValid) {
                loadingOverlay.classList.add('active');

                // Симуляция загрузки (в реальном приложении удалить)
                setTimeout(() => {
                    loadingOverlay.classList.remove('active');
                }, 1500);
            } else {
                e.preventDefault();

                // Прокрутка к первой ошибке
                const firstError = loginForm.querySelector('.error');
                if (firstError) {
                    firstError.scrollIntoView({
                        behavior: 'smooth',
                        block: 'center'
                    });
                }
            }
        });

        // Удаление класса ошибки при вводе
        loginForm.querySelectorAll('input').forEach(field => {
            field.addEventListener('input', function() {
                this.classList.remove('error');
            });
        });

        // Анимация при фокусе
        loginForm.querySelectorAll('.form-input').forEach(field => {
            field.addEventListener('focus', function() {
                this.parentElement.parentElement.style.transform = 'translateY(-5px)';
            });

            field.addEventListener('blur', function() {
                this.parentElement.parentElement.style.transform = 'translateY(0)';
            });
        });

        // Параллакс эффект для фона
        window.addEventListener('scroll', function() {
            const scrolled = window.pageYOffset;
            const background = document.querySelector('.login-background');
            if (background) {
                background.style.transform = `translateY(${scrolled * 0.05}px)`;
            }
        });

        // Анимация чекбокса
        const rememberCheckbox = document.querySelector('.remember-checkbox');
        if (rememberCheckbox) {
            rememberCheckbox.addEventListener('change', function() {
                if (this.checked) {
                    this.style.transform = 'scale(1.1)';
                    setTimeout(() => {
                        this.style.transform = 'scale(1)';
                    }, 300);
                }
            });
        }

        // Эффект при наведении на ссылки
        document.querySelectorAll('.login-link').forEach(link => {
            link.addEventListener('mouseenter', function() {
                this.style.transform = 'translateY(-2px)';
            });

            link.addEventListener('mouseleave', function() {
                this.style.transform = 'translateY(0)';
            });
        });
    });
</script>