<?php
use yii\helpers\Html;
use yii\helpers\Url;

$this->title = 'Weekend Tours | Организация туров выходного дня';
?>

<style>
    :root {
        --primary-green: #4CAF7D;
        --light-green: #E8F5E9;
        --accent-green: #81C784;
        --dark-green: #388E3C;
        --white: #FFFFFF;
        --gray-light: #F5F5F5;
        --gray: #757575;
    }

    * {
        margin: 0;
        padding: 0;
        box-sizing: border-box;
    }

    body {
        font-family: 'Inter', 'Segoe UI', sans-serif;
        background: linear-gradient(135deg, var(--light-green) 0%, var(--white) 100%);
        min-height: 100vh;
        overflow-x: hidden;
    }

    /* Анимированный фон */
    .background-animation {
        position: fixed;
        top: 0;
        left: 0;
        width: 100%;
        height: 100%;
        z-index: -1;
        opacity: 0.3;
    }

    .floating-circle {
        position: absolute;
        border-radius: 50%;
        background: rgba(76, 175, 125, 0.1);
        animation: float 20s infinite linear;
    }

    .floating-circle:nth-child(1) {
        width: 300px;
        height: 300px;
        top: 10%;
        left: 5%;
        animation-delay: 0s;
    }

    .floating-circle:nth-child(2) {
        width: 200px;
        height: 200px;
        top: 60%;
        right: 10%;
        animation-delay: -5s;
    }

    .floating-circle:nth-child(3) {
        width: 150px;
        height: 150px;
        bottom: 20%;
        left: 20%;
        animation-delay: -10s;
    }

    @keyframes float {
        0%, 100% {
            transform: translateY(0) rotate(0deg);
        }
        33% {
            transform: translateY(-30px) rotate(120deg);
        }
        66% {
            transform: translateY(30px) rotate(240deg);
        }
    }

    /* Основные стили */
    .container {
        max-width: 1200px;
        margin: 0 auto;
        padding: 0 20px;
    }

    section {
        position: relative;
        z-index: 1;
    }

    /* 1. Блок о портале */
    .hero-section {
        padding: 80px 0;
        position: relative;
        overflow: hidden;
    }

    .hero-section::before {
        content: '';
        position: absolute;
        top: 0;
        left: 0;
        width: 100%;
        height: 100%;
        background: linear-gradient(45deg, transparent 60%, rgba(76, 175, 125, 0.05) 100%);
        z-index: -1;
    }

    .hero-title {
        font-size: 3.5rem;
        font-weight: 800;
        background: linear-gradient(45deg, var(--dark-green), var(--primary-green));
        -webkit-background-clip: text;
        -webkit-text-fill-color: transparent;
        margin-bottom: 20px;
        opacity: 0;
        transform: translateY(30px);
        animation: fadeInUp 1s ease forwards;
    }

    .hero-subtitle {
        font-size: 1.2rem;
        color: var(--gray);
        margin-bottom: 40px;
        opacity: 0;
        transform: translateY(30px);
        animation: fadeInUp 1s ease 0.3s forwards;
    }

    .features-grid {
        display: grid;
        grid-template-columns: repeat(auto-fit, minmax(300px, 1fr));
        gap: 30px;
        margin-top: 50px;
    }

    .feature-card {
        background: var(--white);
        padding: 30px;
        border-radius: 20px;
        box-shadow: 0 10px 30px rgba(76, 175, 125, 0.1);
        transition: all 0.4s ease;
        opacity: 0;
        transform: translateY(40px);
    }

    .feature-card:hover {
        transform: translateY(-10px);
        box-shadow: 0 20px 40px rgba(76, 175, 125, 0.15);
    }

    .feature-card:nth-child(1) { animation: fadeInUp 1s ease 0.4s forwards; }
    .feature-card:nth-child(2) { animation: fadeInUp 1s ease 0.6s forwards; }
    .feature-card:nth-child(3) { animation: fadeInUp 1s ease 0.8s forwards; }

    .feature-card h4 {
        color: var(--dark-green);
        margin-bottom: 20px;
        font-size: 1.5rem;
    }

    .feature-card ul {
        list-style: none;
    }

    .feature-card li {
        padding: 8px 0;
        color: var(--gray);
        position: relative;
        padding-left: 25px;
    }

    .feature-card li::before {
        content: '✓';
        position: absolute;
        left: 0;
        color: var(--primary-green);
        font-weight: bold;
    }

    .gallery-grid {
        display: grid;
        grid-template-columns: repeat(2, 1fr);
        gap: 15px;
        margin: 20px 0;
    }

    .gallery-grid img {
        width: 100%;
        height: 200px;
        object-fit: cover;
        border-radius: 10px;
        transition: transform 0.3s ease;
    }

    .gallery-grid img:hover {
        transform: scale(1.03);
    }

    .video-container {
        position: relative;
        border-radius: 10px;
        overflow: hidden;
        box-shadow: 0 10px 30px rgba(0,0,0,0.1);
        transition: transform 0.3s ease;
    }

    .video-container:hover {
        transform: scale(1.02);
    }

    .video-container iframe {
        width: 100%;
        height: 250px;
    }

    /* 2. Каталог туров */
    .tours-section {
        padding: 80px 0;
    }

    .section-title {
        font-size: 2.5rem;
        color: var(--dark-green);
        margin-bottom: 40px;
        text-align: center;
        position: relative;
    }

    .section-title::after {
        content: '';
        position: absolute;
        bottom: -10px;
        left: 50%;
        transform: translateX(-50%);
        width: 100px;
        height: 3px;
        background: var(--primary-green);
        border-radius: 2px;
    }

    .tours-grid {
        display: grid;
        grid-template-columns: repeat(auto-fill, minmax(350px, 1fr));
        gap: 30px;
    }

    .tour-card {
        background: var(--white);
        border-radius: 20px;
        overflow: hidden;
        box-shadow: 0 10px 30px rgba(76, 175, 125, 0.1);
        transition: all 0.4s ease;
        opacity: 0;
        transform: translateY(40px);
        animation: fadeInUp 0.8s ease forwards;
    }

    .tour-card:hover {
        transform: translateY(-10px);
        box-shadow: 0 20px 40px rgba(76, 175, 125, 0.15);
    }

    .tour-card:nth-child(1) { animation-delay: 0.1s; }
    .tour-card:nth-child(2) { animation-delay: 0.2s; }
    .tour-card:nth-child(3) { animation-delay: 0.3s; }
    .tour-card:nth-child(4) { animation-delay: 0.4s; }
    .tour-card:nth-child(5) { animation-delay: 0.5s; }
    .tour-card:nth-child(6) { animation-delay: 0.6s; }

    .tour-image {
        width: 100%;
        height: 250px;
        object-fit: cover;
        transition: transform 0.5s ease;
    }

    .tour-card:hover .tour-image {
        transform: scale(1.05);
    }

    .tour-content {
        padding: 25px;
    }

    .tour-title {
        font-size: 1.3rem;
        color: var(--dark-green);
        margin-bottom: 10px;
    }

    .tour-description {
        color: var(--gray);
        margin-bottom: 15px;
        line-height: 1.6;
    }

    .tour-price {
        font-size: 1.5rem;
        color: var(--primary-green);
        font-weight: 700;
        margin-bottom: 20px;
    }

    .btn-primary {
        display: inline-block;
        padding: 12px 30px;
        background: linear-gradient(45deg, var(--primary-green), var(--accent-green));
        color: var(--white);
        text-decoration: none;
        border-radius: 25px;
        border: none;
        font-weight: 600;
        transition: all 0.3s ease;
        cursor: pointer;
    }

    .btn-primary:hover {
        transform: translateY(-2px);
        box-shadow: 0 10px 20px rgba(76, 175, 125, 0.3);
        color: var(--white);
    }

    /* 3. Блок услуг */
    .services-section {
        padding: 80px 0;
        background: linear-gradient(135deg, var(--white) 0%, var(--light-green) 100%);
    }

    .services-list {
        display: flex;
        justify-content: center;
        gap: 40px;
        flex-wrap: wrap;
    }

    .service-item {
        text-align: center;
        padding: 30px;
        min-width: 200px;
        opacity: 0;
        transform: translateY(30px);
        animation: fadeInUp 0.8s ease forwards;
    }

    .service-item:nth-child(1) { animation-delay: 0.1s; }
    .service-item:nth-child(2) { animation-delay: 0.2s; }
    .service-item:nth-child(3) { animation-delay: 0.3s; }

    .service-icon {
        width: 80px;
        height: 80px;
        background: var(--white);
        border-radius: 50%;
        margin: 0 auto 20px;
        display: flex;
        align-items: center;
        justify-content: center;
        font-size: 2rem;
        color: var(--primary-green);
        box-shadow: 0 10px 20px rgba(76, 175, 125, 0.1);
        transition: all 0.3s ease;
    }

    .service-item:hover .service-icon {
        transform: scale(1.1) rotate(10deg);
        background: var(--primary-green);
        color: var(--white);
    }

    .service-item h3 {
        color: var(--dark-green);
        margin-bottom: 10px;
    }

    /* 4. Отзывы участников */
    .reviews-section {
        padding: 80px 0;
    }

    .reviews-slider {
        display: grid;
        grid-template-columns: repeat(auto-fill, minmax(300px, 1fr));
        gap: 30px;
        perspective: 1000px;
    }

    .review-card {
        background: var(--white);
        padding: 30px;
        border-radius: 20px;
        box-shadow: 0 10px 30px rgba(76, 175, 125, 0.1);
        transition: all 0.4s ease;
        opacity: 0;
        transform: translateY(40px) rotateX(10deg);
        animation: fadeInUp 0.8s ease forwards;
    }

    .review-card:nth-child(1) { animation-delay: 0.1s; }
    .review-card:nth-child(2) { animation-delay: 0.2s; }
    .review-card:nth-child(3) { animation-delay: 0.3s; }

    .review-card:hover {
        transform: translateY(-10px) rotateX(0);
        box-shadow: 0 20px 40px rgba(76, 175, 125, 0.15);
    }

    .review-author {
        font-weight: 600;
        color: var(--dark-green);
        margin-bottom: 10px;
    }

    .review-text {
        color: var(--gray);
        line-height: 1.6;
        margin-bottom: 15px;
    }

    .review-rating {
        color: var(--primary-green);
        font-weight: 600;
    }

    /* 5. Контактная информация */
    .contacts-section {
        padding: 80px 0;
        background: linear-gradient(135deg, var(--light-green) 0%, var(--white) 100%);
    }

    .contact-info {
        display: grid;
        grid-template-columns: repeat(auto-fit, minmax(250px, 1fr));
        gap: 30px;
        max-width: 800px;
        margin: 0 auto;
    }

    .contact-item {
        text-align: center;
        padding: 30px;
        background: var(--white);
        border-radius: 20px;
        box-shadow: 0 10px 30px rgba(76, 175, 125, 0.1);
        transition: all 0.3s ease;
        opacity: 0;
        transform: translateY(30px);
        animation: fadeInUp 0.8s ease forwards;
    }

    .contact-item:nth-child(1) { animation-delay: 0.1s; }
    .contact-item:nth-child(2) { animation-delay: 0.2s; }
    .contact-item:nth-child(3) { animation-delay: 0.3s; }

    .contact-item:hover {
        transform: translateY(-5px);
        box-shadow: 0 15px 35px rgba(76, 175, 125, 0.15);
    }

    .contact-item h3 {
        color: var(--dark-green);
        margin-bottom: 15px;
    }

    .contact-item p {
        color: var(--gray);
    }

    /* 6. Подвал сайта */
    .footer {
        background: var(--dark-green);
        padding: 40px 0;
        position: relative;
        overflow: hidden;
    }

    .footer::before {
        content: '';
        position: absolute;
        top: 0;
        left: 0;
        width: 100%;
        height: 100%;
        background: linear-gradient(45deg, transparent 60%, rgba(255,255,255,0.1) 100%);
    }


    .footer-links {
        display: flex;
        gap: 30px;
        flex-wrap: wrap;
    }

    .footer-links a {
        color: var(--white);
        text-decoration: none;
        transition: all 0.3s ease;
        position: relative;
    }

    .footer-links a::after {
        content: '';
        position: absolute;
        bottom: -5px;
        left: 0;
        width: 0;
        height: 2px;
        background: var(--accent-green);
        transition: width 0.3s ease;
    }

    .footer-links a:hover {
        color: var(--accent-green);
    }

    .footer-links a:hover::after {
        width: 100%;
    }

    /* Анимации */
    @keyframes fadeInUp {
        from {
            opacity: 0;
            transform: translateY(40px);
        }
        to {
            opacity: 1;
            transform: translateY(0);
        }
    }

    /* Адаптивность */
    @media (max-width: 768px) {
        .hero-title {
            font-size: 2.5rem;
        }

        .features-grid,
        .tours-grid,
        .reviews-slider {
            grid-template-columns: 1fr;
        }

        .services-list {
            flex-direction: column;
            align-items: center;
        }


    }

    /* Скролл-анимации */
    .reveal {
        opacity: 0;
        transform: translateY(30px);
        transition: all 0.8s ease;
    }

    .reveal.active {
        opacity: 1;
        transform: translateY(0);
    }
</style>

<!-- Анимированный фон -->
<div class="background-animation">
    <div class="floating-circle"></div>
    <div class="floating-circle"></div>
    <div class="floating-circle"></div>
</div>

<!-- 1. Блок о портале -->
<section class="hero-section reveal">
    <div class="container text-center">
        <h1 class="hero-title">Организация туров выходного дня</h1>
        <p class="hero-subtitle">Лучшие маршруты Урала, комфорт, безопасность и эмоции.</p>

        <div class="features-grid">
            <div class="feature-card">
                <h4>Преимущества</h4>
                <ul>
                    <li>Удобное бронирование</li>
                    <li>Проверенные маршруты</li>
                    <li>Комфорт и безопасность</li>
                    <li>Профессиональные гиды</li>
                    <li>Гибкие даты</li>
                </ul>
            </div>

            <div class="feature-card">
                <h4>Фотоотчеты</h4>
                <div class="gallery-grid">
                    <img src="<?= Url::to(['/images/disney.jpg']) ?>" alt="Тур по Уралу">
                    <img src="<?= Url::to(['/images/turgojak.jpg']) ?>" alt="Природа Урала">
                </div>
            </div>

            <div class="feature-card">
                <h4>Видеоотчет</h4>
                <div class="video-container">
                    <iframe src="https://vk.com/video_ext.php?oid=-46598842&id=456241867&hash=2e9c13a1f64fa2f1"
                            frameborder="0"
                            allowfullscreen="1"
                            allow="autoplay; encrypted-media; fullscreen; picture-in-picture">
                    </iframe>
                </div>
            </div>
        </div>
    </div>
</section>

<!-- 2. Каталог туров -->
<section class="tours-section">
    <div class="container">
        <h2 class="section-title reveal">Каталог туров</h2>
        <div class="tours-grid">
            <?php foreach (array_slice($tours, 0, 6) as $tour): ?>
                <div class="tour-card reveal">
                    <?php if ($tour->image): ?>
                        <img src="<?= Url::to(['/images/' . $tour->image]) ?>"
                             class="tour-image"
                             alt="<?= Html::encode($tour->title) ?>">
                    <?php endif; ?>
                    <div class="tour-content">
                        <h3 class="tour-title"><?= Html::encode($tour->title) ?></h3>
                        <p class="tour-description"><?= Html::encode(mb_substr($tour->description, 0, 100)) ?>...</p>
                        <div class="tour-price"><?= Html::encode($tour->price) ?> ₽</div>
                        <?= Html::a('Подробнее', ['/site/tour', 'id' => $tour->id], ['class' => 'btn-primary']) ?>
                    </div>
                </div>
            <?php endforeach; ?>
        </div>
    </div>
</section>

<!-- 3. Блок услуг -->
<section class="services-section reveal">
    <div class="container">
        <h2 class="section-title">Дополнительные услуги</h2>
        <div class="services-list">
            <div class="service-item">
                <div class="service-icon">🚌</div>
                <h3>Трансфер</h3>
                <p>Комфортный транспорт</p>
            </div>
            <div class="service-item">
                <div class="service-icon">🎤</div>
                <h3>Экскурсии</h3>
                <p>Профессиональные гиды</p>
            </div>
            <div class="service-item">
                <div class="service-icon">🍽️</div>
                <h3>Питание</h3>
                <p>Вкусная и полезная еда</p>
            </div>
        </div>
    </div>
</section>

<!-- 4. Отзывы участников -->
<section class="reviews-section">
    <div class="container">
        <h2 class="section-title reveal">Отзывы участников</h2>
        <div class="reviews-slider">
            <?php foreach ($reviews as $review): ?>
                <div class="review-card reveal">
                    <div class="review-author"><?= Html::encode($review->user->full_name) ?></div>
                    <div class="review-text">"<?= Html::encode($review->text) ?>"</div>
                    <div class="review-rating">Оценка: <?= str_repeat('★', $review->rating) ?></div>
                </div>
            <?php endforeach; ?>
        </div>
    </div>
</section>

<!-- 5. Контактная информация -->
<section class="contacts-section reveal">
    <div class="container">
        <h2 class="section-title">Контакты</h2>
        <div class="contact-info">
            <div class="contact-item">
                <h3>Адрес</h3>
                <p>г. Курган, ул. Пушкина, д. 1</p>
            </div>
            <div class="contact-item">
                <h3>Телефон</h3>
                <p>+7 (900) 000-00-00</p>
            </div>
            <div class="contact-item">
                <h3>Email</h3>
                <p>info@weekendtours.ru</p>
            </div>
        </div>
    </div>
</section>


<script>
    // Анимация появления при скролле
    function reveal() {
        const reveals = document.querySelectorAll('.reveal');

        reveals.forEach(element => {
            const windowHeight = window.innerHeight;
            const elementTop = element.getBoundingClientRect().top;
            const elementVisible = 150;

            if (elementTop < windowHeight - elementVisible) {
                element.classList.add('active');
            }
        });
    }

    window.addEventListener('scroll', reveal);
    reveal(); // Запуск при загрузке

    // Плавный скролл для якорей
    document.querySelectorAll('a[href^="#"]').forEach(anchor => {
        anchor.addEventListener('click', function (e) {
            e.preventDefault();
            const target = document.querySelector(this.getAttribute('href'));
            if (target) {
                target.scrollIntoView({
                    behavior: 'smooth',
                    block: 'start'
                });
            }
        });
    });

    // Параллакс эффект для фона
    window.addEventListener('scroll', () => {
        const scrolled = window.pageYOffset;
        const background = document.querySelector('.background-animation');
        background.style.transform = `translateY(${scrolled * 0.1}px)`;
    });
</script>