<?php

/** @var yii\web\View $this */
/** @var string $content */

use app\assets\AppAsset;
use app\widgets\Alert;
use yii\bootstrap5\Breadcrumbs;
use yii\bootstrap5\Html;
use yii\bootstrap5\Nav;
use yii\bootstrap5\NavBar;

AppAsset::register($this);

$this->registerCsrfMetaTags();
$this->registerMetaTag(['charset' => Yii::$app->charset], 'charset');
$this->registerMetaTag(['name' => 'viewport', 'content' => 'width=device-width, initial-scale=1, shrink-to-fit=no']);
$this->registerMetaTag(['name' => 'description', 'content' => $this->params['meta_description'] ?? '']);
$this->registerMetaTag(['name' => 'keywords', 'content' => $this->params['meta_keywords'] ?? '']);
$this->registerLinkTag(['rel' => 'icon', 'type' => 'image/x-icon', 'href' => Yii::getAlias('@web/favicon.ico')]);

// Определяем активный пункт меню
$currentRoute = Yii::$app->controller->route;
$isHome = $currentRoute === 'site/index';
$isCatalog = strpos($currentRoute, 'catalog') !== false || strpos($currentRoute, 'tour') !== false;
$isLogin = $currentRoute === 'site/login';
$isRegister = $currentRoute === 'site/register';
$isMyBookings = $currentRoute === 'site/my-bookings';
$isAdmin = strpos($currentRoute, 'admin') !== false;
?>
<?php $this->beginPage() ?>
    <!DOCTYPE html>
    <html lang="<?= Yii::$app->language ?>" class="h-100">
    <head>
        <title><?= Html::encode($this->title) ?></title>

        <style>
            :root {
                --primary-green: #4CAF7D;
                --light-green: #E8F5E9;
                --accent-green: #81C784;
                --dark-green: #388E3C;
                --white: #FFFFFF;
                --gray-light: #F5F5F5;
                --gray: #757575;
                --gray-dark: #424242;
                --warning: #FF9800;
                --error: #f44336;
                --blue: #2196F3;
                --purple: #9C27B0;
                --cyan: #00BCD4;
                --nav-dark: #1A3C2E;
            }

            * {
                margin: 0;
                padding: 0;
                box-sizing: border-box;
            }

            body {
                font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
                line-height: 1.6;
                color: var(--gray-dark);
                background: var(--white);
                overflow-x: hidden;
            }

            /* Анимированный фон для всего сайта */
            body::before {
                content: '';
                position: fixed;
                top: 0;
                left: 0;
                width: 100%;
                height: 100%;
                background: linear-gradient(135deg, var(--light-green) 0%, var(--white) 100%);
                z-index: -2;
            }

            body::after {
                content: '';
                position: fixed;
                top: 0;
                left: 0;
                width: 100%;
                height: 100%;
                z-index: -1;
                opacity: 0.03;
                background-image:
                        radial-gradient(circle at 20% 80%, var(--primary-green) 0%, transparent 50%),
                        radial-gradient(circle at 80% 20%, var(--accent-green) 0%, transparent 50%),
                        radial-gradient(circle at 40% 40%, var(--blue) 0%, transparent 50%);
            }

            /* Навигация */
            .navbar {
                background: linear-gradient(135deg, var(--nav-dark) 0%, var(--dark-green) 100%) !important;
                padding: 0 20px;
                box-shadow: 0 4px 30px rgba(0, 0, 0, 0.15);
                height: 80px;
                transition: all 0.4s cubic-bezier(0.175, 0.885, 0.32, 1.275);
                position: fixed;
                top: 0;
                width: 100%;
                z-index: 1000;
            }

            .navbar:hover {
                box-shadow: 0 10px 40px rgba(0, 0, 0, 0.2);
                height: 85px;
            }

            .navbar-brand {
                font-size: 1.8rem;
                font-weight: 800;
                background: linear-gradient(45deg, #FFFFFF, #E8F5E9);
                -webkit-background-clip: text;
                -webkit-text-fill-color: transparent;
                display: flex;
                align-items: center;
                gap: 15px;
                padding: 10px 0;
                transition: all 0.3s ease;
            }

            .navbar-brand:hover {
                transform: translateX(-5px);
            }

            .navbar-brand::before {
                content: '🏔️';
                font-size: 2rem;
                -webkit-text-fill-color: initial;
                animation: mountainFloat 3s ease-in-out infinite;
            }

            @keyframes mountainFloat {
                0%, 100% { transform: translateY(0) rotate(0deg); }
                50% { transform: translateY(-5px) rotate(5deg); }
            }

            .navbar-nav {
                gap: 5px;
            }

            .nav-link {
                color: var(--white) !important;
                font-weight: 500;
                padding: 15px 20px !important;
                border-radius: 50px;
                transition: all 0.3s ease;
                position: relative;
                overflow: hidden;
                display: flex;
                align-items: center;
                gap: 10px;
            }

            .nav-link::before {
                content: '';
                position: absolute;
                top: 0;
                left: -100%;
                width: 100%;
                height: 100%;
                background: linear-gradient(90deg, transparent, rgba(255,255,255,0.1), transparent);
                transition: left 0.5s ease;
            }

            .nav-link:hover::before {
                left: 100%;
            }

            .nav-link:hover {
                background: rgba(255, 255, 255, 0.15);
                transform: translateY(-2px);
                box-shadow: 0 5px 15px rgba(0, 0, 0, 0.1);
            }

            .nav-link.active {
                background: linear-gradient(45deg, var(--primary-green), var(--accent-green));
                color: var(--white) !important;
                box-shadow: 0 5px 20px rgba(76, 175, 125, 0.3);
                transform: translateY(-2px);
            }

            .nav-link.active::after {
                content: '';
                position: absolute;
                bottom: 0;
                left: 50%;
                transform: translateX(-50%);
                width: 30px;
                height: 3px;
                background: var(--white);
                border-radius: 2px;
            }

            /* Иконки для пунктов меню */
            .nav-link[href*="index"]::before { content: '🏠'; }
            .nav-link[href*="catalog"]::before { content: '🗺️'; }
            .nav-link[href*="login"]::before { content: '🔑'; }
            .nav-link[href*="register"]::before { content: '📝'; }
            .nav-link[href*="my-bookings"]::before { content: '📋'; }
            .nav-link[href*="admin"]::before { content: '👑'; }

            .logout {
                background: rgba(244, 67, 54, 0.15) !important;
                border: 2px solid rgba(244, 67, 54, 0.3);
                padding: 12px 25px !important;
            }

            .logout:hover {
                background: rgba(244, 67, 54, 0.25) !important;
                border-color: rgba(244, 67, 54, 0.5);
            }

            /* Кнопка меню для мобильных */
            .navbar-toggler {
                border: 2px solid rgba(255, 255, 255, 0.3);
                padding: 8px 12px;
                border-radius: 10px;
                transition: all 0.3s ease;
            }

            .navbar-toggler:hover {
                border-color: var(--primary-green);
                transform: rotate(90deg);
            }

            .navbar-toggler-icon {
                background-image: url("data:image/svg+xml,%3csvg xmlns='http://www.w3.org/2000/svg' viewBox='0 0 30 30'%3e%3cpath stroke='rgba%28255, 255, 255, 0.8%29' stroke-linecap='round' stroke-miterlimit='10' stroke-width='2' d='M4 7h22M4 15h22M4 23h22'/%3e%3c/svg%3e");
            }

            /* Основной контент */
            main#main {
                min-height: calc(100vh - 180px);
                padding-top: 100px;
                padding-bottom: 80px;
                position: relative;
            }

            .container {
                max-width: 1400px;
                margin: 0 auto;
                padding: 0 20px;
                position: relative;
                z-index: 1;
            }

            /* Хлебные крошки */
            .breadcrumb {
                background: var(--white);
                border-radius: 15px;
                padding: 20px 30px;
                box-shadow: 0 5px 20px rgba(0, 0, 0, 0.08);
                margin-bottom: 30px;
                border: 2px solid var(--light-green);
                animation: slideInDown 0.5s ease;
            }

            .breadcrumb-item {
                color: var(--gray);
                font-size: 0.95rem;
            }

            .breadcrumb-item a {
                color: var(--primary-green);
                text-decoration: none;
                font-weight: 500;
                transition: all 0.3s ease;
                display: inline-flex;
                align-items: center;
                gap: 5px;
            }

            .breadcrumb-item a:hover {
                color: var(--dark-green);
                transform: translateX(-3px);
            }

            .breadcrumb-item.active {
                color: var(--dark-green);
                font-weight: 600;
            }

            .breadcrumb-item + .breadcrumb-item::before {
                content: '›';
                color: var(--gray);
                font-size: 1.2rem;
            }

            /* Уведомления */
            .alert {
                border-radius: 15px;
                padding: 20px 25px;
                margin-bottom: 30px;
                border: none;
                box-shadow: 0 5px 20px rgba(0, 0, 0, 0.1);
                animation: slideInDown 0.5s ease;
                display: flex;
                align-items: center;
                gap: 15px;
                position: relative;
                overflow: hidden;
            }

            .alert::before {
                content: '';
                position: absolute;
                left: 0;
                top: 0;
                width: 5px;
                height: 100%;
            }

            .alert-success {
                background: rgba(76, 175, 125, 0.1);
                color: var(--dark-green);
                border-left: 5px solid var(--primary-green);
            }

            .alert-success::before {
                background: var(--primary-green);
            }

            .alert-danger {
                background: rgba(244, 67, 54, 0.1);
                color: var(--error);
                border-left: 5px solid var(--error);
            }

            .alert-danger::before {
                background: var(--error);
            }

            .alert-warning {
                background: rgba(255, 152, 0, 0.1);
                color: var(--warning);
                border-left: 5px solid var(--warning);
            }

            .alert-warning::before {
                background: var(--warning);
            }

            .alert-info {
                background: rgba(33, 150, 243, 0.1);
                color: var(--blue);
                border-left: 5px solid var(--blue);
            }

            .alert-info::before {
                background: var(--blue);
            }

            /* Футер */


            .contact-info {
                display: flex;
                flex-direction: column;
                gap: 15px;
            }

            .contact-item {
                display: flex;
                align-items: center;
                gap: 15px;
                color: rgba(255, 255, 255, 0.8);
            }

            .contact-item i {
                font-size: 1.2rem;
                color: var(--primary-green);
            }

            .social-links {
                display: flex;
                gap: 15px;
                margin-top: 20px;
            }

            .social-link {
                width: 45px;
                height: 45px;
                border-radius: 50%;
                background: rgba(255, 255, 255, 0.1);
                display: flex;
                align-items: center;
                justify-content: center;
                color: var(--white);
                text-decoration: none;
                transition: all 0.3s ease;
                font-size: 1.2rem;
            }

            .social-link:hover {
                background: var(--primary-green);
                transform: translateY(-5px) rotate(10deg);
                box-shadow: 0 10px 20px rgba(0, 0, 0, 0.2);
            }

            .copyright {
                text-align: center;
                padding-top: 30px;
                border-top: 1px solid rgba(255, 255, 255, 0.1);
                color: rgba(255, 255, 255, 0.6);
                font-size: 0.9rem;
                position: relative;
                z-index: 1;
            }

            /* Анимации */
            @keyframes slideInDown {
                from {
                    opacity: 0;
                    transform: translateY(-30px);
                }
                to {
                    opacity: 1;
                    transform: translateY(0);
                }
            }

            @keyframes fadeIn {
                from { opacity: 0; }
                to { opacity: 1; }
            }

            /* Кастомный скроллбар */
            ::-webkit-scrollbar {
                width: 10px;
            }

            ::-webkit-scrollbar-track {
                background: var(--light-green);
                border-radius: 5px;
            }

            ::-webkit-scrollbar-thumb {
                background: linear-gradient(45deg, var(--primary-green), var(--accent-green));
                border-radius: 5px;
            }

            ::-webkit-scrollbar-thumb:hover {
                background: linear-gradient(45deg, var(--dark-green), var(--primary-green));
            }

            /* Адаптивность */
            @media (max-width: 991.98px) {
                .navbar {
                    height: auto;
                    padding: 15px 20px;
                }

                .navbar-nav {
                    background: rgba(26, 60, 46, 0.95);
                    padding: 20px;
                    border-radius: 15px;
                    margin-top: 15px;
                    backdrop-filter: blur(10px);
                }

                .nav-link {
                    margin-bottom: 10px;
                }

                main#main {
                    padding-top: 120px;
                }
            }

            @media (max-width: 768px) {
                .navbar-brand {
                    font-size: 1.5rem;
                }


                .container {
                    padding: 0 15px;
                }
            }

            @media (max-width: 576px) {
                .navbar-brand {
                    font-size: 1.3rem;
                }

                .nav-link {
                    padding: 12px 15px !important;
                    font-size: 0.95rem;
                }

                .alert {
                    padding: 15px 20px;
                    font-size: 0.9rem;
                }

                .breadcrumb {
                    padding: 15px 20px;
                }
            }

            /* Эффект прокрутки для навигации */
            .navbar.scrolled {
                height: 70px;
                box-shadow: 0 10px 30px rgba(0, 0, 0, 0.2);
                backdrop-filter: blur(10px);
                background: linear-gradient(135deg, rgba(26, 60, 46, 0.95) 0%, rgba(56, 142, 60, 0.95) 100%) !important;
            }

            .navbar.scrolled .navbar-brand {
                font-size: 1.6rem;
            }

            /* Кнопка "Наверх" */
            .scroll-to-top {
                position: fixed;
                bottom: 30px;
                right: 30px;
                width: 50px;
                height: 50px;
                background: linear-gradient(45deg, var(--primary-green), var(--accent-green));
                color: var(--white);
                border: none;
                border-radius: 50%;
                font-size: 1.5rem;
                cursor: pointer;
                transition: all 0.4s cubic-bezier(0.175, 0.885, 0.32, 1.275);
                box-shadow: 0 5px 20px rgba(76, 175, 125, 0.3);
                z-index: 100;
                display: flex;
                align-items: center;
                justify-content: center;
                opacity: 0;
                visibility: hidden;
                transform: translateY(20px);
            }

            .scroll-to-top.visible {
                opacity: 1;
                visibility: visible;
                transform: translateY(0);
            }

            .scroll-to-top:hover {
                transform: translateY(-10px) scale(1.1);
                box-shadow: 0 15px 30px rgba(76, 175, 125, 0.4);
            }

            /* Индикатор загрузки страницы */
            .page-loader {
                position: fixed;
                top: 0;
                left: 0;
                width: 100%;
                height: 3px;
                background: var(--light-green);
                z-index: 9999;
                overflow: hidden;
            }

            .page-loader::before {
                content: '';
                position: absolute;
                top: 0;
                left: 0;
                height: 100%;
                width: 50%;
                background: linear-gradient(90deg, var(--primary-green), var(--accent-green));
                animation: loading 2s infinite ease-in-out;
            }

            @keyframes loading {
                0% { transform: translateX(-100%); }
                100% { transform: translateX(400%); }
            }

            /* Эффект для активной страницы */
            .page-transition {
                animation: fadeIn 0.5s ease;
            }
        </style>

        <?php $this->head() ?>
    </head>
    <body class="d-flex flex-column h-100">
    <?php $this->beginBody() ?>

    <!-- Индикатор загрузки -->
    <div class="page-loader"></div>

    <!-- Кнопка "Наверх" -->
    <button class="scroll-to-top" onclick="scrollToTop()">↑</button>

    <header id="header">
        <?php
        NavBar::begin([
            'brandLabel' => 'Туры выходного дня',
            'brandUrl' => Yii::$app->homeUrl,
            'options' => [
                'class' => 'navbar-expand-lg navbar'
            ],
        ]);

        $menuItems = [
            [
                'label' => 'Главная',
                'url' => ['/site/index'],
                'active' => $isHome,
                'linkOptions' => ['class' => $isHome ? 'nav-link active' : 'nav-link']
            ],
            [
                'label' => 'Каталог туров',
                'url' => ['/site/catalog'],
                'active' => $isCatalog,
                'linkOptions' => ['class' => $isCatalog ? 'nav-link active' : 'nav-link']
            ],
        ];

        if (Yii::$app->user->isGuest) {
            // ГОСТЬ
            $menuItems[] = [
                'label' => 'Вход',
                'url' => ['/site/login'],
                'active' => $isLogin,
                'linkOptions' => ['class' => $isLogin ? 'nav-link active' : 'nav-link']
            ];
            $menuItems[] = [
                'label' => 'Регистрация',
                'url' => ['/site/register'],
                'active' => $isRegister,
                'linkOptions' => ['class' => $isRegister ? 'nav-link active' : 'nav-link']
            ];
        } else {
            // АВТОРИЗОВАННЫЙ
            if (Yii::$app->user->identity->role === 'user') {
                $menuItems[] = [
                    'label' => 'Мои заявки',
                    'url' => ['/site/my-bookings'],
                    'active' => $isMyBookings,
                    'linkOptions' => ['class' => $isMyBookings ? 'nav-link active' : 'nav-link']
                ];
            }

            // АДМИН
            if (Yii::$app->user->identity->role === 'admin') {
                $menuItems[] = [
                    'label' => 'Админ-панель',
                    'url' => ['/admin/index'],
                    'active' => $isAdmin,
                    'linkOptions' => ['class' => $isAdmin ? 'nav-link active' : 'nav-link']
                ];
            }

            // ВЫХОД
            $menuItems[] = '<li class="nav-item">'
                . Html::beginForm(['/site/logout'], 'post', ['class' => 'd-inline'])
                . Html::submitButton(
                    'Выход (' . Html::encode(Yii::$app->user->identity->email) . ')',
                    [
                        'class' => 'nav-link btn btn-link logout',
                        'style' => 'color: white !important;'
                    ]
                )
                . Html::endForm()
                . '</li>';
        }

        echo Nav::widget([
            'options' => ['class' => 'navbar-nav ms-auto'],
            'items' => $menuItems,
            'encodeLabels' => false,
        ]);

        NavBar::end();
        ?>
    </header>

    <main id="main" class="flex-shrink-0 page-transition" role="main">
        <div class="container">
            <?php if (!empty($this->params['breadcrumbs'])): ?>
                <nav aria-label="breadcrumb">
                    <?= Breadcrumbs::widget([
                        'links' => $this->params['breadcrumbs'],
                        'options' => ['class' => 'breadcrumb'],
                        'itemTemplate' => '<li class="breadcrumb-item">{link}</li>',
                        'activeItemTemplate' => '<li class="breadcrumb-item active" aria-current="page">{link}</li>'
                    ]) ?>
                </nav>
            <?php endif ?>

            <?= Alert::widget() ?>

            <div class="content-wrapper">
                <?= $content ?>
            </div>
        </div>
    </main>



    <script>
        document.addEventListener('DOMContentLoaded', function() {
            // Эффект прокрутки для навигации
            const navbar = document.querySelector('.navbar');
            const scrollToTopBtn = document.querySelector('.scroll-to-top');
            const pageLoader = document.querySelector('.page-loader');

            // Убираем индикатор загрузки
            setTimeout(() => {
                pageLoader.style.opacity = '0';
                setTimeout(() => {
                    pageLoader.remove();
                }, 500);
            }, 800);

            // Обработчик прокрутки
            window.addEventListener('scroll', function() {
                // Эффект для навигации
                if (window.scrollY > 50) {
                    navbar.classList.add('scrolled');
                } else {
                    navbar.classList.remove('scrolled');
                }

                // Кнопка "Наверх"
                if (window.scrollY > 300) {
                    scrollToTopBtn.classList.add('visible');
                } else {
                    scrollToTopBtn.classList.remove('visible');
                }

                // Параллакс эффект для фона
                const scrolled = window.pageYOffset;
                document.body.style.backgroundPositionY = `${scrolled * 0.05}px`;
            });

            // Прокрутка к началу страницы
            window.scrollToTop = function() {
                window.scrollTo({
                    top: 0,
                    behavior: 'smooth'
                });
            };

            // Эффект для ссылок в навигации
            document.querySelectorAll('.nav-link').forEach(link => {
                link.addEventListener('mouseenter', function() {
                    this.style.transform = 'translateY(-2px) scale(1.05)';
                });

                link.addEventListener('mouseleave', function() {
                    this.style.transform = 'translateY(0) scale(1)';
                });
            });

            // Анимация для иконок соцсетей
            document.querySelectorAll('.social-link').forEach(link => {
                link.addEventListener('mouseenter', function() {
                    this.style.transform = 'translateY(-5px) rotate(10deg)';
                });

                link.addEventListener('mouseleave', function() {
                    this.style.transform = 'translateY(0) rotate(0)';
                });
            });

            // Эффект печати для заголовка сайта
            const siteTitle = document.querySelector('.navbar-brand');
            const originalText = siteTitle.textContent;
            siteTitle.textContent = '';

            let i = 0;
            function typeWriter() {
                if (i < originalText.length) {
                    siteTitle.textContent += originalText.charAt(i);
                    i++;
                    setTimeout(typeWriter, 100);
                }
            }

            // Запускаем эффект печати
            setTimeout(typeWriter, 500);

            // Анимация появления контента
            const contentElements = document.querySelectorAll('.content-wrapper > *');
            contentElements.forEach((element, index) => {
                element.style.opacity = '0';
                element.style.transform = 'translateY(30px)';

                setTimeout(() => {
                    element.style.transition = 'all 0.6s ease';
                    element.style.opacity = '1';
                    element.style.transform = 'translateY(0)';
                }, 100 + (index * 100));
            });


            // Интерактивная карта в футере (демо)


            // Автоматическое скрытие уведомлений через 5 секунд
            setTimeout(() => {
                document.querySelectorAll('.alert').forEach(alert => {
                    alert.style.opacity = '0';
                    alert.style.transform = 'translateX(100%)';
                    setTimeout(() => {
                        if (alert.parentNode) {
                            alert.parentNode.removeChild(alert);
                        }
                    }, 300);
                });
            }, 5000);

            // Эффект пульсации для активного пункта меню
            setInterval(() => {
                const activeLink = document.querySelector('.nav-link.active');
                if (activeLink) {
                    activeLink.style.boxShadow = '0 5px 20px rgba(76, 175, 125, 0.3)';
                    setTimeout(() => {
                        activeLink.style.boxShadow = '0 5px 20px rgba(76, 175, 125, 0.5)';
                    }, 500);
                }
            }, 1000);

            // Добавляем иконку для кнопки выхода
            const logoutBtn = document.querySelector('.logout');
            if (logoutBtn) {
                const icon = document.createElement('span');
                icon.textContent = '🚪';
                icon.style.marginRight = '8px';
                logoutBtn.insertBefore(icon, logoutBtn.firstChild);
            }
        });

        // Обработчик перед уходом со страницы
        window.addEventListener('beforeunload', function() {
            document.body.style.opacity = '0.5';
            document.body.style.transition = 'opacity 0.3s ease';
        });
    </script>

    <?php $this->endBody() ?>
    </body>
    </html>
<?php $this->endPage() ?>