<?php

use yii\helpers\Url;
use yii\widgets\ActiveForm;
use yii\helpers\Html;

$this->title = $model->isNewRecord ? 'Создать тур' : 'Редактировать тур';
?>

<style>
    :root {
        --primary-green: #4CAF7D;
        --light-green: #E8F5E9;
        --accent-green: #81C784;
        --dark-green: #388E3C;
        --white: #FFFFFF;
        --gray-light: #F5F5F5;
        --gray: #757575;
        --gray-dark: #424242;
        --warning: #FF9800;
        --error: #f44336;
        --blue: #2196F3;
        --purple: #9C27B0;
        --cyan: #00BCD4;
    }

    .tour-form-page {
        min-height: 100vh;
        background: linear-gradient(135deg, var(--light-green) 0%, var(--white) 100%);
        padding: 40px 0;
        position: relative;
        overflow: hidden;
    }

    /* Анимированный фон */
    .tour-form-background {
        position: absolute;
        top: 0;
        left: 0;
        width: 100%;
        height: 100%;
        z-index: 0;
        opacity: 0.1;
    }

    .tour-form-shape {
        position: absolute;
        border-radius: 50%;
        background: var(--primary-green);
        filter: blur(60px);
        opacity: 0.3;
        animation: float 20s infinite ease-in-out;
    }

    .tour-form-shape:nth-child(1) {
        width: 400px;
        height: 400px;
        top: -100px;
        right: -100px;
        animation-delay: 0s;
    }

    .tour-form-shape:nth-child(2) {
        width: 300px;
        height: 300px;
        bottom: -50px;
        left: -50px;
        animation-delay: -5s;
    }

    .tour-form-shape:nth-child(3) {
        width: 200px;
        height: 200px;
        top: 30%;
        left: 15%;
        animation-delay: -10s;
        background: var(--warning);
    }

    @keyframes float {
        0%, 100% {
            transform: translate(0, 0) rotate(0deg);
        }
        33% {
            transform: translate(30px, 30px) rotate(120deg);
        }
        66% {
            transform: translate(-20px, 40px) rotate(240deg);
        }
    }

    /* Основной контейнер */
    .tour-form-container {
        position: relative;
        z-index: 1;
        max-width: 800px;
        margin: 0 auto;
        padding: 0 20px;
    }

    /* Заголовок */
    .tour-form-header {
        text-align: center;
        margin-bottom: 50px;
        opacity: 0;
        transform: translateY(30px);
        animation: fadeInUp 0.8s ease forwards;
    }

    .tour-form-title {
        font-size: 3rem;
        font-weight: 800;
        background: linear-gradient(45deg, var(--dark-green), var(--warning));
        -webkit-background-clip: text;
        -webkit-text-fill-color: transparent;
        margin-bottom: 15px;
    }

    .tour-form-subtitle {
        font-size: 1.2rem;
        color: var(--gray);
        max-width: 600px;
        margin: 0 auto;
    }

    /* Форма */
    .tour-form-section {
        opacity: 0;
        transform: translateY(30px);
        animation: fadeInUp 0.8s ease 0.3s forwards;
    }

    .form-card {
        background: var(--white);
        border-radius: 20px;
        padding: 50px;
        box-shadow: 0 20px 50px rgba(0, 0, 0, 0.1);
        position: relative;
        overflow: hidden;
    }

    .form-card::before {
        content: '';
        position: absolute;
        top: 0;
        left: 0;
        width: 100%;
        height: 5px;
        background: linear-gradient(90deg, var(--primary-green), var(--warning));
    }

    /* Поля формы */
    .form-group {
        margin-bottom: 35px;
        position: relative;
    }

    .form-label {
        display: block;
        margin-bottom: 12px;
        color: var(--dark-green);
        font-weight: 700;
        font-size: 1.1rem;
        display: flex;
        align-items: center;
        gap: 10px;
    }

    .form-label::after {
        content: '*';
        color: var(--error);
        font-size: 1.3rem;
        opacity: 0.7;
    }

    .form-label.optional::after {
        content: '';
    }

    .form-input,
    .form-textarea {
        width: 100%;
        padding: 20px 25px;
        border: 2px solid var(--light-green);
        border-radius: 15px;
        font-size: 1.1rem;
        color: var(--gray-dark);
        background: var(--white);
        transition: all 0.4s cubic-bezier(0.175, 0.885, 0.32, 1.275);
        outline: none;
        font-family: inherit;
    }

    .form-input:focus,
    .form-textarea:focus {
        border-color: var(--primary-green);
        box-shadow: 0 0 0 6px rgba(76, 175, 125, 0.15);
        transform: translateY(-5px);
    }

    .form-input::placeholder,
    .form-textarea::placeholder {
        color: var(--gray);
        opacity: 0.6;
    }

    .form-textarea {
        min-height: 150px;
        resize: vertical;
        line-height: 1.6;
    }

    /* Поле цены */
    .price-field {
        position: relative;
    }

    .price-field::after {
        content: '₽';
        position: absolute;
        right: 25px;
        top: 50%;
        transform: translateY(-50%);
        font-size: 1.3rem;
        font-weight: 700;
        color: var(--primary-green);
        z-index: 1;
    }

    /* Загрузка изображения */
    .image-upload-section {
        background: rgba(76, 175, 125, 0.05);
        border: 2px dashed var(--light-green);
        border-radius: 15px;
        padding: 40px;
        text-align: center;
        margin: 30px 0;
        transition: all 0.4s ease;
        position: relative;
        overflow: hidden;
    }

    .image-upload-section:hover {
        border-color: var(--primary-green);
        background: rgba(76, 175, 125, 0.1);
        transform: translateY(-5px);
    }

    .image-upload-area {
        cursor: pointer;
    }

    .upload-icon {
        font-size: 4rem;
        color: var(--primary-green);
        margin-bottom: 20px;
        display: block;
        transition: transform 0.3s ease;
    }

    .image-upload-area:hover .upload-icon {
        transform: scale(1.2) rotate(10deg);
    }

    .upload-text h3 {
        color: var(--dark-green);
        margin-bottom: 10px;
        font-size: 1.3rem;
    }

    .upload-text p {
        color: var(--gray);
        margin-bottom: 20px;
        font-size: 0.95rem;
    }

    .file-input {
        display: none;
    }

    .file-label {
        display: inline-block;
        padding: 14px 30px;
        background: linear-gradient(45deg, var(--primary-green), var(--accent-green));
        color: var(--white);
        border-radius: 50px;
        font-weight: 600;
        cursor: pointer;
        transition: all 0.3s ease;
    }

    .file-label:hover {
        transform: translateY(-3px);
        box-shadow: 0 10px 25px rgba(76, 175, 125, 0.3);
    }

    .file-name {
        display: block;
        margin-top: 15px;
        color: var(--gray);
        font-size: 0.9rem;
        word-break: break-all;
    }

    /* Предпросмотр изображения */
    .image-preview {
        margin-top: 30px;
        text-align: center;
        animation: fadeIn 0.5s ease;
    }

    .current-image-title {
        font-weight: 600;
        color: var(--dark-green);
        margin-bottom: 15px;
        display: flex;
        align-items: center;
        justify-content: center;
        gap: 10px;
    }

    .current-image-title::before {
        content: '🖼️';
        font-size: 1.2rem;
    }

    .preview-container {
        position: relative;
        display: inline-block;
        margin: 0 auto;
    }

    .image-preview img {
        max-width: 300px;
        max-height: 300px;
        border-radius: 15px;
        box-shadow: 0 15px 35px rgba(0, 0, 0, 0.15);
        transition: all 0.4s ease;
    }

    .image-preview img:hover {
        transform: scale(1.05);
        box-shadow: 0 20px 45px rgba(0, 0, 0, 0.2);
    }

    .remove-image {
        position: absolute;
        top: -10px;
        right: -10px;
        width: 40px;
        height: 40px;
        background: var(--error);
        color: var(--white);
        border: none;
        border-radius: 50%;
        font-size: 1.2rem;
        cursor: pointer;
        display: flex;
        align-items: center;
        justify-content: center;
        transition: all 0.3s ease;
        box-shadow: 0 5px 15px rgba(244, 67, 54, 0.3);
        z-index: 2;
    }

    .remove-image:hover {
        transform: scale(1.1) rotate(90deg);
        box-shadow: 0 8px 20px rgba(244, 67, 54, 0.4);
    }

    /* Счетчик символов */
    .char-counter {
        text-align: right;
        font-size: 0.9rem;
        color: var(--gray);
        margin-top: 8px;
    }

    .char-counter.warning {
        color: var(--warning);
    }

    .char-counter.error {
        color: var(--error);
    }

    /* Кнопка отправки */
    .submit-section {
        margin-top: 50px;
        padding-top: 40px;
        border-top: 2px solid var(--light-green);
        text-align: center;
    }

    .submit-button {
        display: inline-flex;
        align-items: center;
        justify-content: center;
        gap: 15px;
        padding: 22px 50px;
        background: linear-gradient(45deg, var(--primary-green), var(--accent-green));
        color: var(--white);
        border: none;
        border-radius: 15px;
        font-size: 1.3rem;
        font-weight: 700;
        cursor: pointer;
        transition: all 0.5s cubic-bezier(0.175, 0.885, 0.32, 1.275);
        position: relative;
        overflow: hidden;
        min-width: 250px;
        box-shadow: 0 15px 35px rgba(76, 175, 125, 0.25);
    }

    .submit-button::before {
        content: '';
        position: absolute;
        top: 0;
        left: -100%;
        width: 100%;
        height: 100%;
        background: linear-gradient(90deg, transparent, rgba(255,255,255,0.2), transparent);
        transition: left 0.6s ease;
    }

    .submit-button:hover::before {
        left: 100%;
    }

    .submit-button:hover {
        transform: translateY(-8px) scale(1.05);
        box-shadow: 0 25px 50px rgba(76, 175, 125, 0.4);
    }

    .submit-button:active {
        transform: translateY(-4px);
    }

    .submit-button::after {
        content: '💾';
        font-size: 1.5rem;
        transition: transform 0.3s ease;
    }

    .submit-button:hover::after {
        transform: scale(1.3);
    }

    .submit-hint {
        color: var(--gray);
        font-size: 0.9rem;
        margin-top: 20px;
    }

    /* Кнопки действий */
    .form-actions {
        display: flex;
        gap: 20px;
        margin-top: 40px;
        flex-wrap: wrap;
    }

    .action-btn {
        flex: 1;
        min-width: 150px;
        display: flex;
        align-items: center;
        justify-content: center;
        gap: 10px;
        padding: 18px 25px;
        border-radius: 12px;
        font-weight: 600;
        font-size: 1rem;
        transition: all 0.3s ease;
        text-decoration: none;
        border: none;
        cursor: pointer;
        text-align: center;
    }

    .action-btn:hover {
        transform: translateY(-3px);
        box-shadow: 0 10px 25px rgba(0, 0, 0, 0.1);
    }

    .btn-cancel {
        background: var(--light-green);
        color: var(--gray-dark);
    }

    .btn-cancel:hover {
        background: var(--gray-light);
    }

    .btn-preview {
        background: linear-gradient(45deg, var(--blue), #64B5F6);
        color: var(--white);
    }

    /* Анимации */
    @keyframes fadeInUp {
        from {
            opacity: 0;
            transform: translateY(40px);
        }
        to {
            opacity: 1;
            transform: translateY(0);
        }
    }

    @keyframes fadeIn {
        from { opacity: 0; }
        to { opacity: 1; }
    }

    /* Валидация */
    .form-input.error,
    .form-textarea.error {
        border-color: var(--error);
        animation: shake 0.5s ease;
    }

    @keyframes shake {
        0%, 100% { transform: translateX(0); }
        25% { transform: translateX(-5px); }
        75% { transform: translateX(5px); }
    }

    .error-message {
        color: var(--error);
        font-size: 0.9rem;
        margin-top: 8px;
        display: flex;
        align-items: center;
        gap: 5px;
    }

    .error-message::before {
        content: '⚠️';
    }

    /* Загрузка */
    .loading-overlay {
        position: fixed;
        top: 0;
        left: 0;
        width: 100%;
        height: 100%;
        background: rgba(255,255,255,0.9);
        display: flex;
        flex-direction: column;
        align-items: center;
        justify-content: center;
        z-index: 1000;
        opacity: 0;
        visibility: hidden;
        transition: all 0.3s ease;
    }

    .loading-overlay.active {
        opacity: 1;
        visibility: visible;
    }

    .loading-spinner {
        width: 60px;
        height: 60px;
        border: 4px solid var(--light-green);
        border-top-color: var(--primary-green);
        border-radius: 50%;
        animation: spin 1s linear infinite;
        margin-bottom: 20px;
    }

    @keyframes spin {
        to { transform: rotate(360deg); }
    }

    /* Кнопка назад */
    .back-button {
        display: inline-flex;
        align-items: center;
        gap: 10px;
        padding: 12px 25px;
        background: var(--white);
        color: var(--gray-dark);
        text-decoration: none;
        border-radius: 50px;
        font-weight: 500;
        margin-bottom: 30px;
        transition: all 0.3s ease;
        box-shadow: 0 5px 15px rgba(76, 175, 125, 0.1);
    }

    .back-button:hover {
        background: var(--light-green);
        color: var(--dark-green);
        transform: translateX(-5px);
    }

    .back-button::before {
        content: '←';
        transition: transform 0.3s ease;
    }

    .back-button:hover::before {
        transform: translateX(-5px);
    }

    /* Кастомный скроллбар */
    ::-webkit-scrollbar {
        width: 8px;
    }

    ::-webkit-scrollbar-track {
        background: var(--light-green);
        border-radius: 4px;
    }

    ::-webkit-scrollbar-thumb {
        background: var(--primary-green);
        border-radius: 4px;
    }

    ::-webkit-scrollbar-thumb:hover {
        background: var(--dark-green);
    }

    /* Адаптивность */
    @media (max-width: 768px) {
        .tour-form-title {
            font-size: 2.2rem;
        }

        .form-card {
            padding: 30px;
        }

        .submit-button {
            min-width: 100%;
            padding: 20px;
        }

        .form-actions {
            flex-direction: column;
        }

        .action-btn {
            width: 100%;
        }

        .image-upload-section {
            padding: 30px;
        }
    }

    @media (max-width: 576px) {
        .tour-form-title {
            font-size: 1.8rem;
        }

        .form-card {
            padding: 20px;
        }

        .form-input,
        .form-textarea {
            padding: 16px 20px;
            font-size: 1rem;
        }

        .image-preview img {
            max-width: 100%;
        }
    }

    /* Редактор текста (упрощенный) */
    .textarea-toolbar {
        display: flex;
        gap: 10px;
        margin-bottom: 10px;
        flex-wrap: wrap;
    }

    .toolbar-btn {
        padding: 8px 15px;
        background: var(--light-green);
        border: none;
        border-radius: 8px;
        cursor: pointer;
        color: var(--gray-dark);
        font-weight: 500;
        transition: all 0.3s ease;
    }

    .toolbar-btn:hover {
        background: var(--primary-green);
        color: var(--white);
        transform: translateY(-2px);
    }
</style>

<div class="tour-form-page">
    <!-- Анимированный фон -->
    <div class="tour-form-background">
        <div class="tour-form-shape"></div>
        <div class="tour-form-shape"></div>
        <div class="tour-form-shape"></div>
    </div>

    <div class="container tour-form-container">
        <!-- Кнопка назад -->
        <a href="<?= \yii\helpers\Url::to(['admin/tours']) ?>" class="back-button reveal">
            Назад к списку туров
        </a>

        <!-- Заголовок -->
        <div class="tour-form-header reveal">
            <h1 class="tour-form-title">
                <?= Html::encode($model->isNewRecord ? 'Создание нового тура' : 'Редактирование тура') ?>
            </h1>
            <p class="tour-form-subtitle">
                <?= $model->isNewRecord
                    ? 'Заполните форму ниже, чтобы добавить новый тур в систему'
                    : 'Внесите необходимые изменения в информацию о туре' ?>
            </p>
        </div>

        <!-- Форма -->
        <div class="tour-form-section reveal">
            <div class="form-card">
                <?php $form = ActiveForm::begin([
                    'id' => 'tour-form',
                    'options' => ['enctype' => 'multipart/form-data'],
                    'enableClientValidation' => true,
                ]); ?>

                <!-- Название тура -->
                <div class="form-group">
                    <label class="form-label">
                        <span>🏔️</span>
                        Название тура
                    </label>
                    <?= $form->field($model, 'title', [
                        'template' => '{input}{error}',
                    ])->textInput([
                        'class' => 'form-input',
                        'required' => true,
                        'placeholder' => 'Например: "Горный поход на Эльбрус"',
                        'maxlength' => 100
                    ])->label(false) ?>
                    <div class="char-counter" id="title-counter">
                    </div>
                </div>

                <!-- Описание -->
                <div class="form-group">
                    <label class="form-label">
                        <span>📝</span>
                        Описание тура
                    </label>
                    <div class="textarea-toolbar">

                    </div>
                    <?= $form->field($model, 'description', [
                        'template' => '{input}{error}',
                    ])->textarea([
                        'class' => 'form-textarea',
                        'required' => true,
                        'placeholder' => 'Подробное описание тура, его особенности и преимущества...',
                        'rows' => 6,
                        'maxlength' => 1000
                    ])->label(false) ?>
                    <div class="char-counter" id="description-counter">
                    </div>
                </div>

                <!-- Программа -->
                <div class="form-group">
                    <label class="form-label">
                        <span>📋</span>
                        Программа тура
                    </label>
                    <div class="textarea-toolbar">
                    </div>
                    <?= $form->field($model, 'program', [
                        'template' => '{input}{error}',
                    ])->textarea([
                        'class' => 'form-textarea',
                        'required' => true,
                        'placeholder' => 'Детальное описание программы по дням/времени...',
                        'rows' => 8,
                        'maxlength' => 2000
                    ])->label(false) ?>
                    <div class="char-counter" id="program-counter">
                    </div>
                </div>

                <!-- Цена -->
                <div class="form-group">
                    <label class="form-label">
                        <span>💰</span>
                        Стоимость тура
                    </label>
                    <div class="price-field">
                        <?= $form->field($model, 'price', [
                            'template' => '{input}{error}',
                        ])->input('number', [
                            'class' => 'form-input',
                            'required' => true,
                            'min' => 0,
                            'placeholder' => 'Введите стоимость в рублях'
                        ])->label(false) ?>
                    </div>
                    <div class="hint" style="color: var(--gray); font-size: 0.9rem; margin-top: 8px;">
                        Цена указана за одного человека
                    </div>
                </div>

                <!-- Загрузка изображения -->
                <div class="image-upload-section">
                    <div class="image-upload-area" onclick="document.getElementById('imageFile').click()">
                        <span class="upload-icon">🖼️</span>
                        <div class="upload-text">
                            <h3>Загрузите изображение тура</h3>
                            <p>Перетащите файл сюда или нажмите для выбора</p>

                        </div>
                    </div>

                    <?= $form->field($model, 'imageFile', [
                        'template' => '{input}{error}',
                        'options' => ['style' => 'display: none;']
                    ])->fileInput([
                        'class' => 'file-input',
                        'id' => 'imageFile',
                        'accept' => 'image/*'
                    ])->label(false) ?>

                    <div class="file-name" id="fileName">
                        Файл не выбран
                    </div>

                    <!-- Предпросмотр текущего изображения -->
                    <?php if (!$model->isNewRecord && $model->image): ?>
                        <div class="image-preview">
                            <div class="current-image-title">
                                Текущее изображение
                            </div>
                            <div class="preview-container">
                                <img src="<?= Html::encode($model->getImageUrl()) ?>"
                                     alt="<?= Html::encode($model->title) ?>"
                                     id="currentImage">
                                <button type="button" class="remove-image" onclick="removeCurrentImage()" title="Удалить изображение">
                                    ×
                                </button>
                            </div>
                            <div class="hint" style="color: var(--gray); font-size: 0.9rem; margin-top: 10px;">
                                Новое изображение заменит текущее
                            </div>
                        </div>
                    <?php endif; ?>

                    <!-- Предпросмотр нового изображения -->
                    <div class="image-preview" id="newImagePreview" style="display: none;">
                        <div class="current-image-title">
                            Новое изображение
                        </div>
                        <div class="preview-container">
                            <img src="" alt="Предпросмотр" id="previewImage">
                            <button type="button" class="remove-image" onclick="removeNewImage()" title="Удалить изображение">
                                ×
                            </button>
                        </div>
                    </div>
                </div>

                <!-- Дополнительные настройки -->

                <!-- Кнопки действий -->
                <div class="form-actions">
                    <a href="<?= \yii\helpers\Url::to(['admin/tours']) ?>" class="action-btn btn-cancel">
                        <span>←</span> Отмена
                    </a>

                    <?php if (!$model->isNewRecord): ?>
                        <a href="<?= Url::to(['site/tour', 'id' => $model->id]) ?>"
                           class="action-btn btn-preview" target="_blank">
                            <span>👁️</span> Предпросмотр
                        </a>
                    <?php endif; ?>

                    <?= Html::submitButton($model->isNewRecord ? 'Создать тур' : 'Сохранить изменения', [
                        'class' => 'submit-button'
                    ]) ?>
                </div>

                <?php ActiveForm::end(); ?>
            </div>
        </div>

        <!-- Оверлей загрузки -->
        <div class="loading-overlay" id="loadingOverlay">
            <div class="loading-spinner"></div>
            <p style="color: var(--dark-green); font-weight: 600;">
                <?= $model->isNewRecord ? 'Создаем тур...' : 'Сохраняем изменения...' ?>
            </p>
        </div>
    </div>
</div>

<script>
    document.addEventListener('DOMContentLoaded', function() {
        // Инициализация анимаций
        const reveals = document.querySelectorAll('.reveal');

        function reveal() {
            reveals.forEach(element => {
                const windowHeight = window.innerHeight;
                const elementTop = element.getBoundingClientRect().top;
                const elementVisible = 100;

                if (elementTop < windowHeight - elementVisible) {
                    element.classList.add('active');
                }
            });
        }

        reveal();
        window.addEventListener('scroll', reveal);

        // Элементы формы
        const tourForm = document.getElementById('tour-form');
        const loadingOverlay = document.getElementById('loadingOverlay');
        const imageFileInput = document.getElementById('imageFile');
        const fileName = document.getElementById('fileName');
        const previewImage = document.getElementById('previewImage');
        const newImagePreview = document.getElementById('newImagePreview');
        const currentImage = document.getElementById('currentImage');

        // Счетчики символов

        // Инициализация счетчиков
        function initCharCounters() {
            updateCharCounter('title');
            updateCharCounter('description');
            updateCharCounter('program');

            // Слушатели событий
            titleInput.addEventListener('input', () => updateCharCounter('title'));
            descriptionInput.addEventListener('input', () => updateCharCounter('description'));
            programInput.addEventListener('input', () => updateCharCounter('program'));
        }

        // Обновление счетчика символов
        function updateCharCounter(field) {
            const input = document.querySelector(`[name*="${field}"]`);
            const counter = document.getElementById(`${field}-counter`);
            const currentSpan = document.getElementById(`${field}-current`);

            if (!input || !counter || !currentSpan) return;

            const length = input.value.length;
            const maxLength = parseInt(input.getAttribute('maxlength')) || 0;

            currentSpan.textContent = length;

            // Обновляем цвет счетчика
            counter.className = 'char-counter';
            if (length > maxLength * 0.9) {
                counter.classList.add('warning');
            }
            if (length > maxLength) {
                counter.classList.add('error');
            }
        }

        // Загрузка и предпросмотр изображения
        imageFileInput.addEventListener('change', function(e) {
            const file = this.files[0];
            if (file) {
                // Показываем имя файла
                fileName.textContent = file.name;
                fileName.style.color = 'var(--dark-green)';
                fileName.style.fontWeight = '600';

                // Предпросмотр изображения
                const reader = new FileReader();
                reader.onload = function(e) {
                    previewImage.src = e.target.result;
                    newImagePreview.style.display = 'block';

                    // Анимация появления
                    newImagePreview.style.opacity = '0';
                    newImagePreview.style.transform = 'translateY(20px)';
                    setTimeout(() => {
                        newImagePreview.style.opacity = '1';
                        newImagePreview.style.transform = 'translateY(0)';
                        newImagePreview.style.transition = 'all 0.5s ease';
                    }, 10);

                    // Скрываем текущее изображение при редактировании
                    if (currentImage) {
                        currentImage.style.opacity = '0.5';
                    }
                };
                reader.readAsDataURL(file);
            } else {
                fileName.textContent = 'Файл не выбран';
                fileName.style.color = 'var(--gray)';
                fileName.style.fontWeight = 'normal';
            }
        });

        // Удаление нового изображения
        window.removeNewImage = function() {
            imageFileInput.value = '';
            fileName.textContent = 'Файл не выбран';
            fileName.style.color = 'var(--gray)';
            fileName.style.fontWeight = 'normal';

            newImagePreview.style.opacity = '0';
            newImagePreview.style.transform = 'translateY(20px)';
            setTimeout(() => {
                newImagePreview.style.display = 'none';
            }, 300);

            // Восстанавливаем текущее изображение
            if (currentImage) {
                currentImage.style.opacity = '1';
            }
        };

        // Удаление текущего изображения
        window.removeCurrentImage = function() {
            if (confirm('Вы уверены, что хотите удалить текущее изображение?')) {
                // В реальном приложении здесь будет AJAX запрос
                // Пока просто скрываем изображение
                const container = currentImage.closest('.preview-container');
                container.style.opacity = '0';
                container.style.transform = 'scale(0.8)';

                setTimeout(() => {
                    container.style.display = 'none';

                    // Добавляем скрытое поле для удаления изображения
                    const hiddenField = document.createElement('input');
                    hiddenField.type = 'hidden';
                    hiddenField.name = 'deleteImage';
                    hiddenField.value = '1';
                    tourForm.appendChild(hiddenField);

                    showNotification('Изображение удалено', 'Изображение будет удалено при сохранении', 'warning');
                }, 300);
            }
        };

        // Форматирование текста
        window.formatText = function(field, type) {
            const textarea = document.querySelector(`[name*="${field}"]`);
            if (!textarea) return;

            const start = textarea.selectionStart;
            const end = textarea.selectionEnd;
            const selectedText = textarea.value.substring(start, end);
            let formattedText = '';

            switch(type) {
                case 'b':
                    formattedText = `<strong>${selectedText}</strong>`;
                    break;
                case 'i':
                    formattedText = `<em>${selectedText}</em>`;
                    break;
                case 'ul':
                    formattedText = `• ${selectedText.replace(/\n/g, '\n• ')}`;
                    break;
                case 'h3':
                    formattedText = `<h3>${selectedText}</h3>`;
                    break;
                case 'day':
                    formattedText = `\n📅 День ${selectedText}:\n• `;
                    break;
                case 'time':
                    formattedText = `⏰ ${selectedText}: `;
                    break;
                case 'activity':
                    formattedText = `🚶 ${selectedText}`;
                    break;
            }

            const newText = textarea.value.substring(0, start) +
                formattedText +
                textarea.value.substring(end);

            textarea.value = newText;
            textarea.focus();
            textarea.setSelectionRange(start, start + formattedText.length);

            updateCharCounter(field);
        };

        // Валидация формы
        tourForm.addEventListener('submit', function(e) {
            let isValid = true;

            // Проверка обязательных полей
            const requiredFields = tourForm.querySelectorAll('[required]');

            requiredFields.forEach(field => {
                if (!field.value.trim()) {
                    field.classList.add('error');
                    isValid = false;

                    // Анимация ошибки
                    field.style.animation = 'none';
                    setTimeout(() => {
                        field.style.animation = 'shake 0.5s ease';
                    }, 10);
                } else {
                    field.classList.remove('error');
                }
            });

            // Проверка максимальной длины
            const checkMaxLength = (input, maxLength) => {
                if (input.value.length > maxLength) {
                    input.classList.add('error');
                    isValid = false;

                    input.style.animation = 'none';
                    setTimeout(() => {
                        input.style.animation = 'shake 0.5s ease';
                    }, 10);
                }
            };

            checkMaxLength(titleInput, 100);
            checkMaxLength(descriptionInput, 1000);
            checkMaxLength(programInput, 2000);



            if (isValid) {
                loadingOverlay.classList.add('active');

                // Симуляция загрузки (в реальном приложении удалить)
                setTimeout(() => {
                    loadingOverlay.classList.remove('active');

                    // Показываем уведомление об успехе
                    showNotification(
                        '<?= $model->isNewRecord ? "Тур создан" : "Изменения сохранены" ?>',
                        '<?= $model->isNewRecord ? "Тур успешно добавлен в систему" : "Информация о туре обновлена" ?>',
                        'success'
                    );

                    // В реальном приложении здесь будет перенаправление
                    // setTimeout(() => {
                    //     window.location.href = '<?= \yii\helpers\Url::to(['admin/tours']) ?>';
                    // }, 2000);
                }, 2000);
            } else {
                e.preventDefault();

                // Прокрутка к первой ошибке
                const firstError = tourForm.querySelector('.error');
                if (firstError) {
                    firstError.scrollIntoView({
                        behavior: 'smooth',
                        block: 'center'
                    });
                }
            }
        });

        // Удаление класса ошибки при вводе
        tourForm.querySelectorAll('input, textarea').forEach(field => {
            field.addEventListener('input', function() {
                this.classList.remove('error');
            });
        });

        // Параллакс эффект для фона
        window.addEventListener('scroll', function() {
            const scrolled = window.pageYOffset;
            const background = document.querySelector('.tour-form-background');
            if (background) {
                background.style.transform = `translateY(${scrolled * 0.05}px)`;
            }
        });

        // Функция показа уведомлений
        function showNotification(title, message, type = 'success') {
            const notification = document.createElement('div');
            notification.className = 'notification';
            notification.style.cssText = `
                position: fixed;
                top: 20px;
                right: 20px;
                background: white;
                padding: 15px 25px;
                border-radius: 10px;
                box-shadow: 0 10px 30px rgba(0,0,0,0.15);
                border-left: 4px solid var(--${type === 'success' ? 'primary-green' : 'warning'});
                z-index: 1000;
                animation: slideInRight 0.3s ease;
                max-width: 350px;
            `;

            notification.innerHTML = `
                <strong>${title}</strong><br>
                <small>${message}</small>
            `;

            document.body.appendChild(notification);

            // Автоматическое удаление через 5 секунд
            setTimeout(() => {
                notification.style.opacity = '0';
                notification.style.transform = 'translateX(100%)';
                setTimeout(() => {
                    if (notification.parentNode) {
                        notification.parentNode.removeChild(notification);
                    }
                }, 300);
            }, 5000);
        }

        // Добавляем CSS для анимации уведомлений
        const style = document.createElement('style');
        style.textContent = `
            @keyframes slideInRight {
                from {
                    transform: translateX(100%);
                    opacity: 0;
                }
                to {
                    transform: translateX(0);
                    opacity: 1;
                }
            }
        `;
        document.head.appendChild(style);

        // Перетаскивание файлов
        const uploadArea = document.querySelector('.image-upload-area');

        ['dragenter', 'dragover', 'dragleave', 'drop'].forEach(eventName => {
            uploadArea.addEventListener(eventName, preventDefaults, false);
        });

        function preventDefaults(e) {
            e.preventDefault();
            e.stopPropagation();
        }

        ['dragenter', 'dragover'].forEach(eventName => {
            uploadArea.addEventListener(eventName, highlight, false);
        });

        ['dragleave', 'drop'].forEach(eventName => {
            uploadArea.addEventListener(eventName, unhighlight, false);
        });

        function highlight() {
            uploadArea.style.transform = 'scale(1.02)';
            uploadArea.style.boxShadow = '0 20px 40px rgba(76, 175, 125, 0.2)';
        }

        function unhighlight() {
            uploadArea.style.transform = 'scale(1)';
            uploadArea.style.boxShadow = 'none';
        }

        uploadArea.addEventListener('drop', handleDrop, false);

        function handleDrop(e) {
            const dt = e.dataTransfer;
            const files = dt.files;

            if (files.length > 0) {
                imageFileInput.files = files;
                imageFileInput.dispatchEvent(new Event('change'));
            }
        }

        // Автосохранение (демо)
        let saveTimeout;
        function autoSave() {
            clearTimeout(saveTimeout);
            saveTimeout = setTimeout(() => {
                console.log('Автосохранение...');
                // В реальном приложении здесь будет AJAX запрос
            }, 30000); // Каждые 30 секунд
        }

        tourForm.querySelectorAll('input, textarea').forEach(field => {
            field.addEventListener('input', autoSave);
        });

        // Инициализация
        initCharCounters();
    });
</script>