<?php
use yii\helpers\Html;

$this->title = 'Админ-панель';
?>

<style>
    :root {
        --primary-green: #4CAF7D;
        --light-green: #E8F5E9;
        --accent-green: #81C784;
        --dark-green: #388E3C;
        --white: #FFFFFF;
        --gray-light: #F5F5F5;
        --gray: #757575;
        --gray-dark: #424242;
        --warning: #FF9800;
        --error: #f44336;
        --blue: #2196F3;
        --purple: #9C27B0;
        --cyan: #00BCD4;
    }

    .admin-page {
        min-height: 100vh;
        background: linear-gradient(135deg, var(--light-green) 0%, var(--white) 100%);
        padding: 40px 0;
        position: relative;
        overflow: hidden;
    }

    /* Анимированный фон */
    .admin-background {
        position: absolute;
        top: 0;
        left: 0;
        width: 100%;
        height: 100%;
        z-index: 0;
        opacity: 0.1;
    }

    .admin-shape {
        position: absolute;
        border-radius: 50%;
        background: var(--primary-green);
        filter: blur(60px);
        opacity: 0.3;
        animation: float 20s infinite ease-in-out;
    }

    .admin-shape:nth-child(1) {
        width: 400px;
        height: 400px;
        top: -100px;
        right: -100px;
        animation-delay: 0s;
    }

    .admin-shape:nth-child(2) {
        width: 300px;
        height: 300px;
        bottom: -50px;
        left: -50px;
        animation-delay: -5s;
    }

    .admin-shape:nth-child(3) {
        width: 250px;
        height: 250px;
        top: 30%;
        left: 15%;
        animation-delay: -10s;
        background: var(--blue);
    }

    .admin-shape:nth-child(4) {
        width: 200px;
        height: 200px;
        bottom: 30%;
        right: 20%;
        animation-delay: -15s;
        background: var(--purple);
    }

    @keyframes float {
        0%, 100% {
            transform: translate(0, 0) rotate(0deg);
        }
        33% {
            transform: translate(30px, 30px) rotate(120deg);
        }
        66% {
            transform: translate(-20px, 40px) rotate(240deg);
        }
    }

    /* Основной контейнер */
    .admin-container {
        position: relative;
        z-index: 1;
        max-width: 1200px;
        margin: 0 auto;
        padding: 0 20px;
    }

    /* Заголовок */
    .admin-header {
        text-align: center;
        margin-bottom: 50px;
        opacity: 0;
        transform: translateY(30px);
        animation: fadeInUp 0.8s ease forwards;
    }

    .admin-title {
        font-size: 3.5rem;
        font-weight: 800;
        background: linear-gradient(45deg, var(--dark-green), var(--blue));
        -webkit-background-clip: text;
        -webkit-text-fill-color: transparent;
        margin-bottom: 15px;
        text-shadow: 0 2px 10px rgba(0, 0, 0, 0.1);
    }

    .welcome-text {
        font-size: 1.3rem;
        color: var(--gray-dark);
        background: var(--white);
        padding: 15px 30px;
        border-radius: 50px;
        display: inline-block;
        box-shadow: 0 5px 15px rgba(76, 175, 125, 0.1);
        margin-top: 20px;
        border: 2px solid var(--light-green);
    }

    .welcome-text strong {
        color: var(--dark-green);
        font-weight: 700;
    }

    /* Статистика */
    .admin-stats {
        display: grid;
        grid-template-columns: repeat(auto-fit, minmax(250px, 1fr));
        gap: 25px;
        margin-bottom: 60px;
        opacity: 0;
        transform: translateY(30px);
        animation: fadeInUp 0.8s ease 0.3s forwards;
    }

    .stat-card {
        background: var(--white);
        border-radius: 20px;
        padding: 30px;
        box-shadow: 0 10px 30px rgba(0, 0, 0, 0.08);
        transition: all 0.4s ease;
        position: relative;
        overflow: hidden;
        border: 2px solid transparent;
    }

    .stat-card::before {
        content: '';
        position: absolute;
        top: 0;
        left: 0;
        width: 6px;
        height: 100%;
        background: var(--primary-green);
        transition: width 0.4s ease;
    }

    .stat-card:hover::before {
        width: 100%;
        opacity: 0.1;
    }

    .stat-card:hover {
        transform: translateY(-10px);
        box-shadow: 0 20px 40px rgba(0, 0, 0, 0.12);
        border-color: var(--primary-green);
    }

    .stat-icon {
        font-size: 3rem;
        margin-bottom: 15px;
        display: block;
        position: relative;
        z-index: 1;
    }

    .stat-value {
        font-size: 2.5rem;
        font-weight: 800;
        color: var(--dark-green);
        margin: 10px 0;
        position: relative;
        z-index: 1;
    }

    .stat-label {
        color: var(--gray);
        font-size: 1rem;
        font-weight: 500;
        position: relative;
        z-index: 1;
    }

    .stat-trend {
        display: inline-flex;
        align-items: center;
        gap: 5px;
        font-size: 0.9rem;
        padding: 4px 12px;
        border-radius: 20px;
        margin-top: 10px;
        background: rgba(76, 175, 125, 0.1);
        color: var(--primary-green);
        font-weight: 600;
        position: relative;
        z-index: 1;
    }

    .stat-trend.up::before {
        content: '↑';
        color: var(--dark-green);
    }

    .stat-trend.down::before {
        content: '↓';
        color: var(--error);
    }

    /* Меню администратора */
    .admin-menu {
        opacity: 0;
        transform: translateY(30px);
        animation: fadeInUp 0.8s ease 0.6s forwards;
    }

    .menu-title {
        font-size: 1.8rem;
        color: var(--dark-green);
        text-align: center;
        margin-bottom: 40px;
        position: relative;
        padding-bottom: 15px;
    }

    .menu-title::after {
        content: '';
        position: absolute;
        bottom: 0;
        left: 50%;
        transform: translateX(-50%);
        width: 100px;
        height: 4px;
        background: linear-gradient(90deg, var(--primary-green), var(--accent-green));
        border-radius: 2px;
    }

    .menu-grid {
        display: grid;
        grid-template-columns: repeat(auto-fit, minmax(280px, 1fr));
        gap: 30px;
    }

    .menu-card {
        background: var(--white);
        border-radius: 20px;
        padding: 40px 30px;
        box-shadow: 0 15px 35px rgba(0, 0, 0, 0.1);
        transition: all 0.4s cubic-bezier(0.175, 0.885, 0.32, 1.275);
        text-align: center;
        border: 2px solid var(--light-green);
        position: relative;
        overflow: hidden;
    }

    .menu-card::before {
        content: '';
        position: absolute;
        top: 0;
        left: 0;
        width: 100%;
        height: 5px;
        background: linear-gradient(90deg, var(--primary-green), var(--accent-green));
        opacity: 0;
        transition: opacity 0.3s ease;
    }

    .menu-card:hover::before {
        opacity: 1;
    }

    .menu-card:hover {
        transform: translateY(-15px) scale(1.03);
        box-shadow: 0 25px 50px rgba(0, 0, 0, 0.15);
        border-color: var(--primary-green);
    }

    .menu-icon {
        font-size: 4rem;
        margin-bottom: 25px;
        display: block;
        transition: transform 0.4s ease;
    }

    .menu-card:hover .menu-icon {
        transform: scale(1.2) rotate(10deg);
    }

    .menu-name {
        font-size: 1.5rem;
        color: var(--dark-green);
        margin-bottom: 15px;
        font-weight: 700;
        transition: color 0.3s ease;
    }

    .menu-card:hover .menu-name {
        color: var(--primary-green);
    }

    .menu-description {
        color: var(--gray);
        font-size: 0.95rem;
        line-height: 1.6;
        margin-bottom: 25px;
    }

    .menu-button {
        display: inline-flex;
        align-items: center;
        justify-content: center;
        gap: 10px;
        padding: 14px 30px;
        background: linear-gradient(45deg, var(--primary-green), var(--accent-green));
        color: var(--white);
        text-decoration: none;
        border-radius: 50px;
        font-weight: 600;
        font-size: 1rem;
        transition: all 0.4s ease;
        position: relative;
        overflow: hidden;
        border: none;
        cursor: pointer;
        width: 100%;
    }

    .menu-button::before {
        content: '';
        position: absolute;
        top: 0;
        left: -100%;
        width: 100%;
        height: 100%;
        background: linear-gradient(90deg, transparent, rgba(255,255,255,0.2), transparent);
        transition: left 0.5s ease;
    }

    .menu-button:hover::before {
        left: 100%;
    }

    .menu-button:hover {
        transform: translateY(-3px);
        box-shadow: 0 10px 25px rgba(76, 175, 125, 0.3);
    }

    .menu-button:active {
        transform: translateY(-1px);
    }

    .menu-button::after {
        content: '→';
        font-size: 1.2rem;
        transition: transform 0.3s ease;
    }

    .menu-button:hover::after {
        transform: translateX(5px);
    }

    /* Кнопки с разными цветами */
    .btn-primary {
        background: linear-gradient(45deg, var(--blue), #64B5F6) !important;
    }

    .btn-primary:hover {
        box-shadow: 0 10px 25px rgba(33, 150, 243, 0.3) !important;
    }

    .btn-success {
        background: linear-gradient(45deg, var(--primary-green), var(--accent-green)) !important;
    }

    .btn-warning {
        background: linear-gradient(45deg, var(--warning), #FFB74D) !important;
    }

    .btn-warning:hover {
        box-shadow: 0 10px 25px rgba(255, 152, 0, 0.3) !important;
    }

    .btn-secondary {
        background: linear-gradient(45deg, var(--purple), #BA68C8) !important;
    }

    .btn-secondary:hover {
        box-shadow: 0 10px 25px rgba(156, 39, 176, 0.3) !important;
    }

    /* Дополнительные действия */
    .quick-actions {
        margin-top: 60px;
        padding: 40px;
        background: var(--white);
        border-radius: 20px;
        box-shadow: 0 15px 35px rgba(0, 0, 0, 0.1);
        opacity: 0;
        transform: translateY(30px);
        animation: fadeInUp 0.8s ease 0.9s forwards;
    }

    .actions-title {
        font-size: 1.6rem;
        color: var(--dark-green);
        margin-bottom: 30px;
        text-align: center;
    }

    .actions-grid {
        display: grid;
        grid-template-columns: repeat(auto-fit, minmax(200px, 1fr));
        gap: 15px;
    }

    .action-btn {
        display: flex;
        align-items: center;
        justify-content: center;
        gap: 10px;
        padding: 15px 20px;
        background: var(--light-green);
        color: var(--dark-green);
        text-decoration: none;
        border-radius: 12px;
        font-weight: 500;
        transition: all 0.3s ease;
        border: 2px solid transparent;
    }

    .action-btn:hover {
        background: var(--primary-green);
        color: var(--white);
        transform: translateY(-3px);
        border-color: var(--primary-green);
        box-shadow: 0 8px 20px rgba(76, 175, 125, 0.2);
    }

    /* Анимации */
    @keyframes fadeInUp {
        from {
            opacity: 0;
            transform: translateY(40px);
        }
        to {
            opacity: 1;
            transform: translateY(0);
        }
    }

    /* Кастомный скроллбар */
    ::-webkit-scrollbar {
        width: 8px;
    }

    ::-webkit-scrollbar-track {
        background: var(--light-green);
        border-radius: 4px;
    }

    ::-webkit-scrollbar-thumb {
        background: var(--primary-green);
        border-radius: 4px;
    }

    ::-webkit-scrollbar-thumb:hover {
        background: var(--dark-green);
    }

    /* Адаптивность */
    @media (max-width: 768px) {
        .admin-title {
            font-size: 2.5rem;
        }

        .admin-stats {
            grid-template-columns: 1fr;
        }

        .menu-grid {
            grid-template-columns: 1fr;
        }

        .stat-value {
            font-size: 2rem;
        }

        .menu-icon {
            font-size: 3rem;
        }
    }

    @media (max-width: 480px) {
        .admin-title {
            font-size: 2rem;
        }

        .welcome-text {
            font-size: 1rem;
            padding: 12px 20px;
        }

        .menu-card {
            padding: 30px 20px;
        }
    }

    /* Уведомления */
    .admin-notifications {
        position: fixed;
        bottom: 20px;
        right: 20px;
        z-index: 1000;
    }

    .notification {
        background: var(--white);
        padding: 15px 25px;
        border-radius: 10px;
        box-shadow: 0 10px 30px rgba(0, 0, 0, 0.15);
        margin-bottom: 10px;
        border-left: 4px solid var(--primary-green);
        animation: slideInRight 0.3s ease;
        max-width: 350px;
    }

    @keyframes slideInRight {
        from {
            transform: translateX(100%);
            opacity: 0;
        }
        to {
            transform: translateX(0);
            opacity: 1;
        }
    }

    /* Время и дата */
    .admin-time {
        text-align: center;
        margin-top: 30px;
        color: var(--gray);
        font-size: 0.9rem;
        opacity: 0;
        transform: translateY(20px);
        animation: fadeInUp 0.8s ease 1.2s forwards;
    }

    .time-display {
        background: rgba(255, 255, 255, 0.9);
        padding: 10px 20px;
        border-radius: 50px;
        display: inline-block;
        border: 2px solid var(--light-green);
        box-shadow: 0 5px 15px rgba(0, 0, 0, 0.05);
    }
</style>

<div class="admin-page">
    <!-- Анимированный фон -->
    <div class="admin-background">
        <div class="admin-shape"></div>
        <div class="admin-shape"></div>
        <div class="admin-shape"></div>
        <div class="admin-shape"></div>
    </div>

    <div class="container admin-container">
        <!-- Заголовок -->
        <div class="admin-header reveal">
            <h1 class="admin-title">Административная панель</h1>
            <div class="welcome-text">
                Добро пожаловать, <strong><?= Html::encode(Yii::$app->user->identity->full_name) ?></strong>!
            </div>
        </div>

        </div>

        <!-- Основное меню -->
        <div class="admin-menu reveal">
            <h2 class="menu-title">Управление системой</h2>

            <div class="menu-grid">
                <!-- Все заявки -->
                <div class="menu-card">
                    <span class="menu-icon">📋</span>
                    <h3 class="menu-name">Все заявки</h3>
                    <p class="menu-description">Просмотр, фильтрация и управление всеми бронированиями туров</p>
                    <?= Html::a(
                        'Перейти к заявкам →',
                        ['admin/index'],
                        ['class' => 'menu-button btn-primary']
                    ) ?>
                </div>

                <!-- Управление турами -->
                <div class="menu-card">
                    <span class="menu-icon">🏔️</span>
                    <h3 class="menu-name">Управление турами</h3>
                    <p class="menu-description">Редактирование существующих туров, изменение цен и описаний</p>
                    <?= Html::a(
                        'Управление турами →',
                        ['admin/tours'],
                        ['class' => 'menu-button btn-success']
                    ) ?>
                </div>

                <!-- Создать новый тур -->
                <div class="menu-card">
                    <span class="menu-icon">✨</span>
                    <h3 class="menu-name">Создать тур</h3>
                    <p class="menu-description">Добавление новых туров с подробным описанием и изображениями</p>
                    <?= Html::a(
                        'Создать тур →',
                        ['admin/create-tour'],
                        ['class' => 'menu-button btn-warning']
                    ) ?>
                </div>

                <!-- Пользователи -->
                <div class="menu-card">
                    <span class="menu-icon">👥</span>
                    <h3 class="menu-name">Пользователи</h3>
                    <p class="menu-description">Управление пользователями, ролями и доступом к системе</p>
                    <?= Html::a(
                        'Управление пользователями →',
                        ['admin/users'],
                        ['class' => 'menu-button btn-secondary']
                    ) ?>
                </div>
            </div>
        </div>



        <!-- Время и дата -->
        <div class="admin-time reveal">
            <div class="time-display">
                <span id="current-date"></span> |
                <span id="current-time"></span>
            </div>
        </div>

        <!-- Уведомления (пример) -->
        <div class="admin-notifications" id="notifications">
            <!-- Уведомления будут добавляться динамически -->
        </div>
    </div>
</div>

<script>
    document.addEventListener('DOMContentLoaded', function() {
        // Инициализация анимаций
        const reveals = document.querySelectorAll('.reveal');

        function reveal() {
            reveals.forEach(element => {
                const windowHeight = window.innerHeight;
                const elementTop = element.getBoundingClientRect().top;
                const elementVisible = 100;

                if (elementTop < windowHeight - elementVisible) {
                    element.classList.add('active');
                }
            });
        }

        reveal();
        window.addEventListener('scroll', reveal);

        // Обновление времени и даты
        function updateDateTime() {
            const now = new Date();

            // Форматирование даты
            const dateOptions = {
                weekday: 'long',
                year: 'numeric',
                month: 'long',
                day: 'numeric'
            };
            const formattedDate = now.toLocaleDateString('ru-RU', dateOptions);

            // Форматирование времени
            const timeOptions = {
                hour: '2-digit',
                minute: '2-digit',
                second: '2-digit',
                hour12: false
            };
            const formattedTime = now.toLocaleTimeString('ru-RU', timeOptions);

            // Обновление DOM
            document.getElementById('current-date').textContent = formattedDate;
            document.getElementById('current-time').textContent = formattedTime;
        }

        // Обновляем время каждую секунду
        updateDateTime();
        setInterval(updateDateTime, 1000);

        // Параллакс эффект для фона
        window.addEventListener('scroll', function() {
            const scrolled = window.pageYOffset;
            const background = document.querySelector('.admin-background');
            if (background) {
                background.style.transform = `translateY(${scrolled * 0.03}px)`;
            }
        });

        // Симуляция уведомлений (демо)
        function showNotification(title, message, type = 'info') {
            const notifications = document.getElementById('notifications');
            const notification = document.createElement('div');
            notification.className = 'notification';

            const colors = {
                'info': 'var(--primary-green)',
                'warning': 'var(--warning)',
                'error': 'var(--error)'
            };

            notification.style.borderLeftColor = colors[type] || colors.info;
            notification.innerHTML = `
                <strong>${title}</strong><br>
                <small>${message}</small>
            `;

            notifications.appendChild(notification);

            // Автоматическое удаление через 5 секунд
            setTimeout(() => {
                notification.style.opacity = '0';
                notification.style.transform = 'translateX(100%)';
                setTimeout(() => {
                    if (notification.parentNode) {
                        notification.parentNode.removeChild(notification);
                    }
                }, 300);
            }, 5000);
        }

        // Демо-уведомления


        // Эффекты при наведении на карточки
        document.querySelectorAll('.menu-card').forEach(card => {
            card.addEventListener('mouseenter', function() {
                this.style.transform = 'translateY(-15px) scale(1.03)';
            });

            card.addEventListener('mouseleave', function() {
                this.style.transform = 'translateY(0) scale(1)';
            });
        });

        // Анимация кнопок
        document.querySelectorAll('.menu-button').forEach(button => {
            button.addEventListener('mouseenter', function() {
                this.style.transform = 'translateY(-3px)';
            });

            button.addEventListener('mouseleave', function() {
                this.style.transform = 'translateY(0)';
            });
        });

        // Обновление статистики (демо)
        function updateStats() {
            const statValues = document.querySelectorAll('.stat-value');

            statValues.forEach(stat => {
                const originalText = stat.textContent;
                const originalValue = parseInt(originalText.replace(/[^0-9]/g, ''));

                // Анимация счетчика
                let current = 0;
                const increment = Math.ceil(originalValue / 100);
                const timer = setInterval(() => {
                    current += increment;
                    if (current >= originalValue) {
                        current = originalValue;
                        clearInterval(timer);
                    }

                    // Сохраняем нечисловые символы
                    const nonNumeric = originalText.replace(/[0-9]/g, '');
                    stat.textContent = current.toLocaleString('ru-RU') + nonNumeric;
                }, 20);
            });
        }

        // Запускаем анимацию статистики
        setTimeout(updateStats, 1000);

        // Эффект печати для заголовка
        const adminTitle = document.querySelector('.admin-title');
        const originalTitle = adminTitle.textContent;
        adminTitle.textContent = '';

        let i = 0;
        function typeWriter() {
            if (i < originalTitle.length) {
                adminTitle.textContent += originalTitle.charAt(i);
                i++;
                setTimeout(typeWriter, 50);
            }
        }

        // Запускаем эффект печати
        setTimeout(typeWriter, 500);

        // Добавляем тень при прокрутке
        window.addEventListener('scroll', function() {
            const header = document.querySelector('.admin-header');
            if (window.scrollY > 50) {
                header.style.transform = 'translateY(-10px)';
                header.style.transition = 'transform 0.3s ease';
            } else {
                header.style.transform = 'translateY(0)';
            }
        });

        // Создаем пульсирующий эффект для важных элементов
        function addPulseEffect() {
            const importantCards = document.querySelectorAll('.menu-card:nth-child(1), .menu-card:nth-child(2)');

            importantCards.forEach(card => {
                card.style.animation = 'pulse 2s infinite';
            });

            // Добавляем CSS для пульсации
            const style = document.createElement('style');
            style.textContent = `
                @keyframes pulse {
                    0% { box-shadow: 0 15px 35px rgba(0, 0, 0, 0.1); }
                    50% { box-shadow: 0 25px 50px rgba(76, 175, 125, 0.2); }
                    100% { box-shadow: 0 15px 35px rgba(0, 0, 0, 0.1); }
                }
            `;
            document.head.appendChild(style);
        }

        // Запускаем эффект пульсации
        setTimeout(addPulseEffect, 3000);
    });
</script>