<?php

namespace app\models;

use yii\db\ActiveRecord;
use yii\web\UploadedFile;

class Tour extends ActiveRecord
{
    /**
     * @var UploadedFile
     */
    public $imageFile;

    public function rules()
    {
        return [
            [['title','description','program','price'],'required'],
            [['price'],'number', 'max' => 1000000],
            [['imageFile'], 'file',
                'skipOnEmpty' => true,
                'extensions' => 'png, jpg, jpeg, gif',
                'checkExtensionByMimeType' => false // отключаем finfo_file
            ],
        ];
    }

    public function upload()
    {
        if ($this->imageFile) {
            $fileName = time() . '_' . $this->imageFile->baseName . '.' . $this->imageFile->extension;
            $path = \Yii::getAlias('@webroot/images/') . $fileName;

            if ($this->imageFile->saveAs($path)) {
                $this->image = $fileName; // сохраняем имя файла в БД
                return true;
            }
            return false;
        }
        return true;
    }

    public function getImageUrl()
    {
        if ($this->image) {
            return \Yii::getAlias('@web') . '/images/' . $this->image;
        }
        return null; // или путь к заглушке, если изображения нет
    }

}
