<?php

namespace app\models;

use yii\db\ActiveRecord;

class Review extends ActiveRecord
{
    public static function tableName() {
        return 'review';
    }

    public function rules() {
        return [
            [['user_id','tour_id','text','rating'],'required'],
            [['rating'],'integer','min'=>1,'max'=>5],
            [['text'],'string'],
        ];
    }

    public function attributeLabels() {
        return [
            'tour_id' => 'Тур',
            'text' => 'Отзыв',
            'rating' => 'Оценка',
        ];
    }

    public function getUser()
    {
        return $this->hasOne(\app\models\User::class, ['id'=>'user_id']);
    }

}
