<?php

namespace app\models;

use yii\base\Model;

class RegisterForm extends Model
{
    public $full_name,$phone,$email,$passport,$address,$password,$password_repeat,$agree;

    public function rules()
    {
        return [
            [['full_name','phone','email','passport','address','password','password_repeat'],'required'],
            ['full_name','match','pattern'=>'/^[А-Яа-я\s]+$/u'],
            ['phone','match','pattern'=>'/^\+7\(\d{3}\)\d{3}-\d{2}-\d{2}$/'],
            ['passport','match','pattern'=>'/^\d{4}\s\d{6}$/'],
            ['email','email'],
            ['password','string','min'=>7],
            ['password_repeat','compare','compareAttribute'=>'password'],
            ['agree','required']
        ];
    }

    public function attributeLabels()
    {
        return [
            'full_name' => 'ФИО',
            'phone' => 'Телефон',
            'email' => 'Электронная почта',
            'passport' => 'Серия и номер паспорта',
            'address' => 'Адрес проживания',
            'password' => 'Пароль',
            'password_repeat' => 'Повторите пароль',
            'agree' => 'Согласие с правилами регистрации',
        ];
    }

    public function register()
    {
        if(!$this->validate()) return false;

        $user = new User();
        $user->full_name = $this->full_name;
        $user->phone = $this->phone;
        $user->email = $this->email;
        $user->passport = $this->passport;
        $user->address = $this->address;
        $user->password_hash = \Yii::$app->security->generatePasswordHash($this->password);
        return $user->save();
    }
}
