<?php

namespace app\models;

use yii\base\Model;
use Yii;

class LoginForm extends Model
{
    public $email;
    public $password;

    public function rules()
    {
        return [
            [['email', 'password'], 'required'],
            ['email', 'email'],
            ['password', 'string'],
        ];
    }

    public function login()
    {
        $user = User::findOne(['email' => $this->email]);

        if (!$user || !Yii::$app->security->validatePassword($this->password, $user->password_hash)) {
            $this->addError('password', 'Неверный email или пароль');
            return false;
        }

        return Yii::$app->user->login($user);
    }
}
