<?php

namespace app\models;

use Yii;
use yii\db\ActiveRecord;

class Booking extends ActiveRecord
{
    public static function tableName() { return 'booking'; }

    public function rules() {
        return [
            [['tour_id','tour_date','persons','payment_method'],'required'],
            [['wishes','comment'], 'safe'],
            ['tour_date', 'compare', 'compareValue' => date('Y-m-d'), 'operator' => '>=',
                'type' => 'string', 'message' => 'Нельзя выбрать прошедшую дату.']
        ];
    }

    public function getTour() {
        return $this->hasOne(Tour::class,['id'=>'tour_id']);
    }

    public function attributeLabels() {
        return [
            'tour_id' => 'Тур',
            'tour_date' => 'Дата тура',
            'persons' => 'Количество участников',
            'wishes' => 'Дополнительные пожелания',
            'comment' => 'Комментарий',
            'payment_method' => 'Способ оплаты',
        ];
    }
    public function getReviews()
    {
        return $this->hasMany(Review::class, ['tour_id' => 'tour_id'])
            ->andWhere(['user_id' => Yii::$app->user->id]);
    }

    public function getUser()
    {
        return $this->hasOne(User::class, ['id'=>'user_id']);
    }

}
