<?php

namespace app\controllers;

use yii\web\Controller;
use yii\filters\AccessControl;
use app\models\{Booking, Tour, User};
use Yii;

class AdminController extends Controller
{
    public function behaviors()
    {
        return [
            'access' => [
                'class' => AccessControl::class,
                'only' => ['index', 'update-status', 'tours', 'create-tour','update-tour','delete-tour','users','delete-user'],
                'rules' => [
                    [
                        'allow' => true,
                        'roles' => ['@'],
                        'matchCallback' => function ($rule, $action) {
                            return Yii::$app->user->identity->role === 'admin';
                        }
                    ],
                ],
                'denyCallback' => function ($rule, $action) {
                    return Yii::$app->response->redirect(['/site/login']);
                },
            ],
        ];
    }

    // Заявки
    public function actionIndex($status = null)
    {
        $query = Booking::find()->joinWith(['user','tour']);
        if ($status) $query->andWhere(['status'=>$status]);
        $bookings = $query->all();
        return $this->render('index', ['bookings'=>$bookings, 'status'=>$status]);
    }

    public function actionUpdateStatus($id,$status)
    {
        $b = Booking::findOne($id);
        if($b){
            $b->status = $status;
            $b->save();
        }
        return $this->redirect(['index']);
    }

    // Туры
    public function actionTours()
    {
        $tours = Tour::find()->all();
        return $this->render('tours', ['tours' => $tours]);
    }

    public function actionCreateTour()
    {
        $model = new \app\models\Tour();

        if ($model->load(\Yii::$app->request->post())) {
            $model->imageFile = \yii\web\UploadedFile::getInstance($model, 'imageFile');
            if ($model->upload() && $model->save()) {
                \Yii::$app->session->setFlash('success', 'Тур успешно создан!');
                return $this->redirect(['tours']);
            }
        }

        return $this->render('tour-form', ['model'=>$model]);
    }


    public function actionUpdateTour($id)
    {
        $model = Tour::findOne($id);
        if (!$model) throw new \yii\web\NotFoundHttpException('Тур не найден');

        if ($model->load(Yii::$app->request->post())) {
            $model->imageFile = \yii\web\UploadedFile::getInstance($model, 'imageFile');
            if ($model->upload() && $model->save()) {
                Yii::$app->session->setFlash('success', 'Тур успешно обновлён!');
                return $this->redirect(['tours']);
            }
        }

        return $this->render('tour-form', ['model' => $model]);
    }

    public function actionDeleteTour($id)
    {
        $model = Tour::findOne($id);
        if ($model) $model->delete();
        return $this->redirect(['tours']);
    }

    // Пользователи
    public function actionUsers()
    {
        return $this->render('users',['users'=>User::find()->all()]);
    }

    public function actionDeleteUser($id)
    {
        $user = User::findOne($id);
        if($user) $user->delete();
        return $this->redirect(['users']);
    }

    public function actionDashboard()
    {
        return $this->render('dashboard');
    }

}
